<?php
/**
 * Main Multi Step Checkout class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Checkout;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\MultiStepCheckoutSettings;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Modules\MultiStepsCheckout\MultiStepsHooks;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Product Description class
 */
class MultiStepCheckout extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Multi Step Checkout ', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-multi-step-checkout';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function widget_fields() {
		return MultiStepCheckoutSettings::widget_settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'Multi Step Checkout' ] + parent::get_keywords();
	}


	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();
		$this->theme_support();

		$template = ( ! empty( $controllers['layout_style'] ) && 'layout1' !== $controllers['layout_style'] )
			? $controllers['layout_style']
			: 'form-checkout';
		$data     = [
			'template'    => 'multi-step-checkout/' . $template,
			'controllers' => $controllers,
			'checkout'    => WC()->checkout(),
			'is_builder'  => $this->is_builder_mode(),
		];

		if ( $this->is_builder_mode() ) {
			wc_load_cart();
		}

		if ( ! Fns::is_module_active( 'multi_step_checkout' ) ) {
			echo '<div class="rtsb-module-not-found" style="text-align: center;">';
			echo '<p>' . esc_html__( 'The MultiStep Checkout Module is currently disabled. Please enable it from dashboard to ensure proper display of the checkout form.', 'shopbuilder-pro' ) . '</p>';
			echo '</div>';
		} else {
			MultiStepsHooks::instance();
			Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
		}

		$this->theme_support( 'render_reset' );
	}
}
