<?php
/**
 * Main AjaxFilters class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Archive;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Render\RenderPro;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\ArchiveFiltersSettings;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Main AjaxFilters class.
 */
class AjaxProductFilters extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Ajax Product Filters', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-ajax-product-filters';

		parent::__construct( $data, $args );
	}

	/**
	 * Keywords
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'filters', 'product filters', 'ajax filters', 'archive filters', 'shop filters' ] + parent::get_keywords();
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function widget_fields() {
		return ArchiveFiltersSettings::widget_fields( $this );
	}

	/**
	 * Script dependencies.
	 *
	 * @return array
	 */
	public function get_script_depends(): array {
		if ( ! $this->is_builder_mode() ) {
			return [];
		}

		return [ 'rtsb-noui-slider' ];
	}

	/**
	 * Style dependencies.
	 *
	 * @return array
	 */
	public function get_style_depends(): array {
		if ( ! $this->is_builder_mode() ) {
			return [];
		}

		return [
			'rtsb-noui-slider',
		];
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->theme_support();

		$layout    = ! empty( $settings['layout'] ) ? $settings['layout'] : 'vertical';
		$templates = [
			'layout'   => 'elementor/archive/product-filters/' . $layout,
			'checkbox' => 'elementor/archive/product-filters/checkbox',
			'radio'    => 'elementor/archive/product-filters/radio',
			'color'    => 'elementor/archive/product-filters/color',
			'button'   => 'elementor/archive/product-filters/button',
			'image'    => 'elementor/archive/product-filters/image',
			'rating'   => 'elementor/archive/product-filters/rating',
			'price'    => 'elementor/archive/product-filters/slider',
		];

		Fns::print_html( RenderPro::filters_view( $templates, $settings ), true );

		$this->edit_mode_script();
		$this->theme_support( 'render_reset' );
	}

}
