<?php

namespace RadiusTheme\SBPRO\Elementor\Helpers;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Helper\ControlSelectors;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Elementor Element List
 */
class ControlSelectorPro {
	/**
	 * Widget List.
	 *
	 * @return array
	 */
	public static function selectors() {
		$selectors = self::thankyou_page_selectors()
					 + self::my_account_page_selectors()
					 + self::product_filters_selectors()
					 + self::product_page_selectors()
					 + self::cart_page_control_selectors()
					 + self::multi_step_checkout_selectors()
					 + self::advanced_product_tabs_selectors()
					 + self::product_stock_count_selectors()
					 + self::highlighted_product_selectors()
					 + self::product_qr_code_selectors()
					 + self::order_pay_selectors();

		return apply_filters( 'rtsb/elements/elementor/widget/selectors/pro', $selectors );
	}

	/**
	 * Cart page coupon selectors.
	 *
	 * @return mixed|null
	 */
	public static function cart_page_control_selectors() {
		$selectors = [
			'rtsb-cart-coupon-form' => [
				'show_title'                 => '{{WRAPPER}} .rtsb-coupon-title',
				// Title Style.
				'title_align'                => '{{WRAPPER}} .rtsb-coupon-title',
				'title_typo'                 => '{{WRAPPER}} .rtsb-coupon-title',
				'title_color'                => '{{WRAPPER}} .rtsb-coupon-title',
				'title_text_stroke'          => '{{WRAPPER}} .rtsb-coupon-title',
				'title_text_shadow'          => '{{WRAPPER}} .rtsb-coupon-title',
				'title_margin'               => '{{WRAPPER}} .rtsb-coupon-title',
				'title_padding'              => '{{WRAPPER}} .rtsb-coupon-title',
				'title_border'               => '{{WRAPPER}} .rtsb-coupon-title',
				// Button Settings.
				'button_typography'          => '{{WRAPPER}} .coupon .button',
				'button_height'              => '{{WRAPPER}} .coupon .button',
				'button_width'               => '{{WRAPPER}} .coupon .button',
				'button_text_color_normal'   => '{{WRAPPER}} .coupon .button',
				'button_bg_color_normal'     => '{{WRAPPER}} .coupon .button',
				'button_border'              => '{{WRAPPER}} .coupon .button',
				'button_text_color_hover'    => '{{WRAPPER}} .coupon .button:hover',
				'button_bg_color_hover'      => '{{WRAPPER}} .coupon .button:hover',
				'button_border_hover_color'  => '{{WRAPPER}} .coupon .button:hover',
				'button_border_radius'       => '{{WRAPPER}} .coupon .button',
				'button_padding'             => '{{WRAPPER}} .coupon .button',
				'button_margin'              => '{{WRAPPER}} .coupon .button',
				'button_icon_size'           => [
					'icon' => '{{WRAPPER}} .coupon .button i',
					'svg'  => '{{WRAPPER}} .coupon .button svg',
				],
				'button_icon_color'          => '{{WRAPPER}} .coupon .button :is(i, svg)',

				// Form Field.
				'fields_height'              => '{{WRAPPER}} #coupon_code',
				'fields_border'              => '{{WRAPPER}} #coupon_code',
				'fields_border_radius'       => '{{WRAPPER}} #coupon_code',
				'fields_text_color'          => '{{WRAPPER}} #coupon_code',
				'fields_bg_color'            => '{{WRAPPER}} #coupon_code',
				'fields_padding'             => '{{WRAPPER}} #coupon_code',

				// Fields Hover.
				'fields_hover_border'        => '{{WRAPPER}} #coupon_code:hover',
				'fields_border_radius_hover' => '{{WRAPPER}} #coupon_code:hover',
				'fields_hover_text_color'    => '{{WRAPPER}} #coupon_code:hover',
				'fields_hover_bg_color'      => '{{WRAPPER}} #coupon_code:hover',

			],
		];

		return apply_filters( 'rtsb/elements/elementor/widget/selectors/pro', $selectors );
	}

	/**
	 * Countdown Common Selectors
	 *
	 * @return string[]
	 */
	public static function countdown_common_selectors() {
		return [
			'counter_number_typography'  => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-number',
			'counter_text_typography'    => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-unit',
			'counter_label_typography'   => '{{WRAPPER}} .rtsb-product-flash-sale-countdown .label-wrapper',
			'counter_height'             => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section,{{WRAPPER}} .rtsb-countdown-campaign.rtsb-countdown-horizontal',
			'counter_width'              => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section,{{WRAPPER}} .rtsb-product-flash-sale-countdown.layout2',
			'counter_gap'                => '{{WRAPPER}} .rtsb-countdown-campaign',
			'counter_text_color_normal'  => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section,{{WRAPPER}} .rtsb-product-flash-sale-countdown .label-wrapper',
			'counter_bg_color_normal'    => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section,{{WRAPPER}} .rtsb-product-flash-sale-countdown.layout2',
			'counter_border'             => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section,{{WRAPPER}} .rtsb-product-flash-sale-countdown.layout2',
			'counter_text_color_hover'   => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section:hover',
			'counter_bg_color_hover'     => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section:hover',
			'counter_border_hover_color' => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section:hover',
			'counter_border_radius'      => '{{WRAPPER}} .rtsb-countdown-campaign .rtsb-countdown-section,{{WRAPPER}} .rtsb-product-flash-sale-countdown.layout2',
			'counter_margin'             => '{{WRAPPER}} .rtsb-products-container .rtsb-product .rtsb-countdown-campaign',
			'element_alignment'          => '{{WRAPPER}} .rtsb-product-flash-sale-countdown',
			'countdown_vertical_gap'     => '{{WRAPPER}} .rtsb-vertical-position-top-right, {{WRAPPER}} .rtsb-vertical-position-top-left,{{WRAPPER}} .rtsb-countdown-vertical.rtsb-countdown-campaign',
			'countdown_vertical_gap_top' => '{{WRAPPER}} .rtsb-vertical-position-top-right, {{WRAPPER}} .rtsb-vertical-position-top-left',
		];
	}

	/**
	 * Returns an array of common CSS selectors used for styling product stock components.
	 *
	 * These selectors are primarily used in Elementor controls to target specific parts
	 * of the product stock display, including text alignment, colors, typography,
	 * padding, margins, borders, progress bar styling, and wrapper layout.
	 *
	 * @since 1.0.0
	 *
	 * @return array Associative array where keys represent setting names and
	 *               values are the corresponding CSS selectors used in the widget.
	 */
	public static function product_stock_count_common_selectors() {
		return [
			'stock_text_align'                      => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
			'product_stock_text_typography'         => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
			'product_stock_count_typography'        => '{{WRAPPER}} .rtsb-product-stock .stock-sold span',
			'product_stock_text_color'              => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
			'product_stock_count_color'             => '{{WRAPPER}} .rtsb-product-stock .stock-sold span',
			'product_stock_count_bgcolor'           => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
			'stock_text_border'                     => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
			'product_stock_text_padding'            => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
			'product_stock_text_margin'             => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
			'product_stock_progress_bg_color'       => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress',
			'product_stock_progress_stock_bg_color' => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress .rtsb-product-stock-progress-bar',
			'product_stock_progress_height'         => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress .rtsb-product-stock-progress-bar',
			'product_stock_border_radius'           => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress .rtsb-product-stock-progress-bar,{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress',
			'product_stock_margin'                  => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress',
			'stock_wrapper_bg'                      => '{{WRAPPER}} .rtsb-product-stock',
			'stock_wrapper_border'                  => '{{WRAPPER}} .rtsb-product-stock',
			'stock_wrapper_border_radius'           => '{{WRAPPER}} .rtsb-product-stock',
			'stock_wrapper_shadow'                  => '{{WRAPPER}} .rtsb-product-stock',
			'stock_wrapper_padding'                 => '{{WRAPPER}} .rtsb-product-stock',
			'stock_wrapper_margin'                  => '{{WRAPPER}} .rtsb-product-stock',
		];
	}
	/**
	 * Returns CSS selectors for styling the product category sale count text.
	 *
	 * This method provides a structured array of Elementor control selectors
	 * for different category layout variations. These selectors target the
	 * typography, color, background color, and hover states of the sale count text.
	 *
	 * @since 1.0.0
	 *
	 * @return array Associative array with keys like 'count_text_typography', 'count_text_color',
	 *               and their corresponding CSS selectors for use in Elementor controls.
	 */
	public static function categories_sale_count() {
		return [
			'category_sale_count_text' => [
				'count_text_typography'     => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout3 .category-wrapper .count-text,{{WRAPPER}} .rtsb-elementor-container .rtsb-category-single-layout2 .category-wrapper .count-text',
				'count_text_color'          => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout3 .category-wrapper .count-text,{{WRAPPER}} .rtsb-elementor-container .rtsb-category-single-layout2 .category-wrapper .count-text',
				'count_text_bg_color'       => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout3 .category-wrapper .count-text,{{WRAPPER}} .rtsb-elementor-container .rtsb-category-single-layout2 .category-wrapper .count-text',
				'count_text_hover_color'    => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout3 .category-wrapper:hover .count-text,{{WRAPPER}} .rtsb-elementor-container .rtsb-category-single-layout2 .category-wrapper:hover .count-text',
				'count_text_hover_bg_color' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout3 .category-wrapper:hover .count-text,{{WRAPPER}} .rtsb-elementor-container .rtsb-category-single-layout2 .category-wrapper:hover .count-text',
			],
		];
	}
	/**
	 * Returns CSS selectors for styling the category link button and its icon.
	 *
	 * Provides a structured array of selectors used in Elementor to customize the
	 * appearance of category link buttons in layout 4 — including icon color,
	 * background, shadow, and hover effects.
	 *
	 * @since 1.0.0
	 *
	 * @return array An associative array where each key corresponds to a control group,
	 *               and values map to individual selectors for styling link icons and backgrounds.
	 *
	 *               Keys include:
	 *               - 'cat_link_icon_color' (string)             Selector for the icon path color.
	 *               - 'cat_link_bg_color' (array)                Background and shadow selectors.
	 *               - 'cat_link_icon_hover_color' (string)       Selector for icon color on hover.
	 *               - 'cat_link_bg_hover_color' (array)          Background and shadow selectors on hover.
	 */
	public static function categories_cat_link_button() {
		return [
			'category_cat_link_button' => [
				'cat_link_icon_color'       => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout4 .category-wrapper .rtsb-category-content .rtsb-link-icon a svg path',
				'cat_link_bg_color'         => [
					'bg'     => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout4 .category-wrapper .rtsb-category-content .rtsb-link-icon a',
					'shadow' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout4',
				],
				'cat_link_icon_hover_color' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout4 .rtsb-category-grid:hover .rtsb-link-icon a svg path,{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout4 .rtsb-category-grid  .rtsb-link-icon a:hover svg path',
				'cat_link_bg_hover_color'   => [
					'bg'     => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout4 .rtsb-category-grid:hover .rtsb-link-icon a',
					'shadow' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout4',
				],
			],
		];
	}

	/**
	 * @return array[]
	 */
	public static function product_page_selectors() {
		return [
			'rtsb-product-sales-count'          => [
				'typo'                   => '{{WRAPPER}} .rtsb-product-sale-count',
				'align'                  => '{{WRAPPER}} .rtsb-product-sale-count',
				'text_color'             => '{{WRAPPER}} .rtsb-product-sale-count',
				'text_shadow'            => '{{WRAPPER}} .rtsb-product-sale-count',
				'total_typo'             => '{{WRAPPER}} .rtsb-product-sale-count .sales-count',
				'total_text_color'       => '{{WRAPPER}} .rtsb-product-sale-count .sales-count',
				'sale_count_icon_color'  => '{{WRAPPER}} .rtsb-product-sale-count :is( i, svg )',
				'sale_count_icon_margin' => '{{WRAPPER}} .rtsb-product-sale-count .icon',
				'icon_size'              => [
					'icon' => '{{WRAPPER}} .rtsb-product-sale-count i',
					'svg'  => '{{WRAPPER}} .rtsb-product-sale-count svg',
				],
			],
			'rtsb-product-size-chart'           => [
				'button_typography'         => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'button_height'             => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'button_width'              => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'button_text_color_normal'  => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'button_bg_color_normal'    => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'button_border'             => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'button_text_color_hover'   => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button:hover',
				'button_bg_color_hover'     => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button:hover',
				'button_border_hover_color' => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button:hover',
				'button_border_radius'      => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'button_padding'            => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'button_margin'             => '{{WRAPPER}} .rtsb-size-chart-wrapper .rtsb-size-chart-button',
				'image_width'               => '{{WRAPPER}} .rtsb-size-chart-wrapper',
				'image_border_radius'       => '{{WRAPPER}} .rtsb-size-chart-wrapper',
				'image_bg_color'            => '{{WRAPPER}} .rtsb-size-chart-wrapper',
				'image_padding'             => '{{WRAPPER}} .rtsb-size-chart-wrapper',
				'image_margin'              => '{{WRAPPER}} .rtsb-size-chart-wrapper',
			],
			'rtsb-product-quick-checkout'       => [
				'button_typography'         => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
				'button_height'             => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
				'button_width'              => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
				'button_text_color_normal'  => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
				'button_bg_color_normal'    => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
				'button_border'             => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
				'button_text_color_hover'   => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn:hover',
				'button_bg_color_hover'     => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn:hover',
				'button_border_hover_color' => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn:hover',
				'button_border_radius'      => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
				'button_padding'            => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
				'button_margin'             => '{{WRAPPER}} .rtsb-product-quick-checkout .rtsb-quick-checkout-btn',
			],
			'rtsb-product-flash-sale-countdown' => self::countdown_common_selectors(),
		];
	}

	/**
	 * Form Field Selectors List.
	 *
	 * @return array
	 */
	public static function form_field_selectors() {
		$defaults = [
			// Label.
			'fields_label_typo'           => '{{WRAPPER}} .rtsb-myacount-page form label',
			'fields_label_color'          => '{{WRAPPER}} .rtsb-myacount-page form label',
			'fields_label_reguired_color' => '{{WRAPPER}} .rtsb-myacount-page form label .required',
			'fields_label_margin'         => '{{WRAPPER}} .rtsb-myacount-page form label',

			// Input Fields.
			'fields_height'               => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
			'fields_border'               => '{{WRAPPER}} .rtsb-myacount-page input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',

			'fields_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',

			'fields_text_color'           => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select,{{WRAPPER}} .rtsb-myacount-page form span em',
			'fields_bg_color'             => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',

			// Hover.
			'fields_hover_border'         => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',

			'fields_border_radius_hover'  => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',

			'fields_hover_text_color'     => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} , {{WRAPPER}} .rtsb-myacount-page form.select2-container--open .select2-selection--single,{{WRAPPER}} .rtsb-myacount-page form span em:is(:hover)',
			'fields_hover_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single',
			'form_heading_typo'           => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page form legend',
			'form_heading_color'          => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page form legend',
			'form_heading_gap'            => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page form legend',
			'form_row_margin'             => '{{WRAPPER}} .rtsb-myacount-page .edit-account .woocommerce-form-row',
			'fields_padding'              => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]),{{WRAPPER}} .rtsb-myacount-page form .select2-container--default .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form :is( select, .select2-selection--single )',
		];

		return apply_filters( 'rtsb/elements/elementor/form_field_selectors', $defaults );
	}

	/**
	 * My Account Page Selectors List.
	 *
	 * @return array
	 */
	public static function my_account_page_table_selectors() {
		$defaults = [
			'table_header_typo'              => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  th,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table th',
			'table_min_width'                => '',
			'table_heading_padding'          => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table thead  th,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table thead th,.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .shop_table thead tr th',
			'table_header_align'             => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  th,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table th',
			'table_header_color'             => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  th,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table th',
			'table_header_bg_color'          => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  th,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table th',
			'table_heading_cell_border'      => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table ,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  tbody td,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table tbody td,.rtsb_theme_hello-elementor {{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table th,.rtsb_theme_hello-elementor {{WRAPPER}} .rtsb-myacount-page  .shop_table th',
			'table_heading_cell_padding'     => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table ,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  tbody td,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table tbody td',
			'show_table_heading'             => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table thead tr,{{WRAPPER}} .rtsb-myacount-page  .shop_table thead tr',
			'table_heading_typography'       => '',
			'table_heading_color'            => '',
			'table_heading_background_color' => '',
			'table_heading_align'            => '',
			'total_heading_width'            => '',
			'table_cell_typography'          => '',
			'table_cell_color'               => '',
			'table_cell_background_color'    => '',
			'table_cell_align'               => '',
			'total_cell_heading_width'       => '',
			'table_item_typo'                => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  tbody td,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table tbody td',
			'table_item_align'               => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  tbody td,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table tbody td',
			'table_item_color'               => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  tbody td,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  tbody td a,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table tbody td,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table tbody td a',
			'table_item_bg_color'            => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-table  tbody td,{{WRAPPER}} .rtsb-myacount-page  .woocommerce-orders-table tbody td',
		];

		return apply_filters( 'rtsb/elements/elementor/myaccount_page_table_selectors', $defaults );
	}

	/**
	 * My Account Page Title Selectors List.
	 *
	 * @return array
	 */
	public static function my_account_page_title_selectors() {
		return [
			// Title Style.
			'title_align'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-downloads h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-customer-details h2',
			'title_typo'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-downloads h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-customer-details h2',
			'title_color'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-downloads h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-customer-details h2',
			'title_text_stroke' => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-downloads h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-customer-details h2',
			'title_text_shadow' => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-downloads h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-customer-details h2',
			'title_margin'      => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-downloads h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-customer-details h2',
			'title_padding'     => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-downloads h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-customer-details h2',
			'title_border'      => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-downloads h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details h2,{{WRAPPER}} .rtsb-myacount-page .woocommerce-customer-details h2',
		];
	}

	/**
	 * Checkout Page Widget List.
	 *
	 * @return array
	 */
	public static function thankyou_page_selectors() {
		$selectors = [
			'rtsb-order-received-text'     => [
				'content_align'             => '{{WRAPPER}} .rtsb-order-thankyou',
				'typo'                      => '{{WRAPPER}} .woocommerce-thankyou-order-received,{{WRAPPER}} .woocommerce-thankyou-order-failed',
				'align'                     => '{{WRAPPER}} .woocommerce-thankyou-order-received,{{WRAPPER}} .woocommerce-thankyou-order-failed',
				'text_color'                => '{{WRAPPER}} .woocommerce-thankyou-order-received,{{WRAPPER}} .woocommerce-thankyou-order-failed',
				'text_shadow'               => '{{WRAPPER}} .woocommerce-thankyou-order-received,{{WRAPPER}} .woocommerce-thankyou-order-failed',

				'button_typography'         => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
				'button_height'             => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
				'button_width'              => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
				'button_text_color_normal'  => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
				'button_bg_color_normal'    => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
				'button_border'             => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
				'button_text_color_hover'   => '{{WRAPPER}} .rtsb-order-thankyou .button.pay:hover',
				'button_bg_color_hover'     => '{{WRAPPER}} .rtsb-order-thankyou .button.pay:hover',
				'button_border_hover_color' => '{{WRAPPER}} .rtsb-order-thankyou .button.pay:hover',
				'button_border_radius'      => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
				'button_padding'            => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
				'button_margin'             => '{{WRAPPER}} .rtsb-order-thankyou .button.pay',
			],
			'rtsb-order-details-summary'   => [
				'view_mode'       => '{{WRAPPER}}  ul.order_details',
				'content_border'  => '{{WRAPPER}}  ul.order_details li',
				'align'           => '{{WRAPPER}}  ul.order_details li',
				'content_padding' => '{{WRAPPER}}  ul.order_details li',
				'content_bg'      => '{{WRAPPER}}  ul.order_details',
				'label_view_mode' => '{{WRAPPER}}  ul.order_details li',
				'label_typo'      => '{{WRAPPER}}  ul.order_details li',
				'label_color'     => '{{WRAPPER}}  ul.order_details li',
				'value_typo'      => '{{WRAPPER}}  ul.order_details li strong',
				'value_color'     => '{{WRAPPER}}  ul.order_details li strong',
			],
			'rtsb-order-details-table'     => [
				'show_title'                     => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				'table_min_width'                => '.rtsb-builder-content {{WRAPPER}} .rtsb-table-horizontal-scroll-on-mobile table.shop_table',
				// Title Style.
				'title_align'                    => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				'title_typo'                     => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				'title_color'                    => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				'title_text_stroke'              => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				'title_text_shadow'              => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				'title_margin'                   => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				'title_padding'                  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				'title_border'                   => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-details__title',
				// Table.
				'table_heading_cell_border'      => '{{WRAPPER}} .rtsb-order-thankyou  .shop_table,{{WRAPPER}} .rtsb-order-thankyou  .shop_table td,{{WRAPPER}} .rtsb-order-thankyou  .shop_table th,{{WRAPPER}} .rtsb-order-thankyou.layout2 .item',
				'table_heading_cell_padding'     => '{{WRAPPER}} .rtsb-order-thankyou .shop_table :is(th, td),{{WRAPPER}} .rtsb-order-thankyou.layout2 .item',
				'table_heading_typography'       => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:first-child, {{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:first-child strong,{{WRAPPER}} .rtsb-order-thankyou .order-single-item .product-name,{{WRAPPER}} .rtsb-order-thankyou .order-single-item .product-name a',
				'table_heading_color'            => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:first-child,{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:first-child a,{{WRAPPER}} .rtsb-order-thankyou .order-single-item .product-name,{{WRAPPER}} .rtsb-order-thankyou .order-single-item .product-name a',
				'table_heading_background_color' => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:first-child,{{WRAPPER}} .rtsb-order-thankyou .order-single-item',
				'table_heading_align'            => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:first-child',
				'total_heading_width'            => '{{WRAPPER}} .rtsb-order-thankyou .shop_table :is(th,td):first-child',
				'table_cell_typography'          => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:nth-child(2), {{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:nth-child(2) strong,{{WRAPPER}} .rtsb-order-thankyou .order-single-item .product-total,{{WRAPPER}} .rtsb-order-thankyou .footer-item div',
				'table_cell_color'               => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:nth-child(2),{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:nth-child(2) a,{{WRAPPER}} .rtsb-order-thankyou .order-single-item .product-total,{{WRAPPER}} .rtsb-order-thankyou .footer-item div',
				'table_cell_background_color'    => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:nth-child(2)',
				'table_cell_align'               => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tbody td:nth-child(2)',
				'total_cell_heading_width'       => '{{WRAPPER}} .rtsb-order-thankyou .shop_table :is(th,td):nth-child(2)',
				'table_header_typo'              => '{{WRAPPER}} .rtsb-order-thankyou .shop_table thead th,.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou .order-header div',
				'table_header_align'             => '{{WRAPPER}} .rtsb-order-thankyou .shop_table thead th',
				'table_header_color'             => '{{WRAPPER}} .rtsb-order-thankyou .shop_table thead th,.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou .order-header div',
				'table_header_bg_color'          => '{{WRAPPER}} .rtsb-order-thankyou .shop_table thead th,.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou .order-header',
				'table_footer_typo'              => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tfoot :is( th, td ),{{WRAPPER}} .rtsb-order-thankyou .footer-item .label',
				'table_footer_align'             => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tfoot :is( th, td )',
				'table_footer_color'             => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tfoot :is( th, td ),{{WRAPPER}} .rtsb-order-thankyou .footer-item .label',
				'table_footer_bg_color'          => '{{WRAPPER}} .rtsb-order-thankyou .shop_table tfoot :is( th, td ),{{WRAPPER}} .rtsb-order-thankyou .footer-item',
				'button_typography'              => '{{WRAPPER}} .rtsb-order-thankyou .button',
				'button_height'                  => '{{WRAPPER}} .rtsb-order-thankyou .button',
				'button_width'                   => '{{WRAPPER}} .rtsb-order-thankyou .button',
				'button_text_color_normal'       => '{{WRAPPER}} .rtsb-order-thankyou .button',
				'button_bg_color_normal'         => '{{WRAPPER}} .rtsb-order-thankyou .button',
				'button_border'                  => '{{WRAPPER}} .rtsb-order-thankyou .button',
				'button_text_color_hover'        => '{{WRAPPER}} .rtsb-order-thankyou .button:hover',
				'button_bg_color_hover'          => '{{WRAPPER}} .rtsb-order-thankyou .button:hover',
				'button_border_hover_color'      => '{{WRAPPER}} .rtsb-order-thankyou .button:hover',
				'button_border_radius'           => '{{WRAPPER}} .rtsb-order-thankyou .button',
				'button_padding'                 => '{{WRAPPER}} .rtsb-order-thankyou .button',
				'button_margin'                  => '{{WRAPPER}} .rtsb-order-thankyou .button',
			],
			'rtsb-downloadable-products'   => [
				'show_title'                     => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				// Title Style.
				'table_min_width'                => '',
				'title_align'                    => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				'title_typo'                     => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				'title_color'                    => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				'title_text_stroke'              => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				'title_text_shadow'              => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				'title_margin'                   => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				'title_padding'                  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				'title_border'                   => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-order-downloads__title',
				// Table.
				'table_header_typo'              => '{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads th',
				'table_heading_padding'          => '{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads th',
				'table_header_align'             => '{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads th',
				'table_header_color'             => '{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads th',
				'table_header_bg_color'          => '{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads th',
				'table_heading_cell_border'      => '{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads,{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads tbody td,.rtsb_theme_hello-elementor {{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads th',
				'table_heading_cell_padding'     => '{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads,{{WRAPPER}} .rtsb-order-thankyou  .woocommerce-table--order-downloads tbody td',
				'show_table_heading'             => '{{WRAPPER}} .rtsb-myacount-page  .shop_table thead tr,{{WRAPPER}} .rtsb-order-thankyou  .shop_table thead tr',
				'table_heading_typography'       => '',
				'table_heading_color'            => '',
				'table_heading_background_color' => '',
				'table_heading_align'            => '',
				'total_heading_width'            => '',
				'table_cell_typography'          => '',
				'table_cell_color'               => '',
				'table_cell_background_color'    => '',
				'table_cell_align'               => '',
				'total_cell_heading_width'       => '',
				'table_item_typo'                => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td',
				'table_item_align'               => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td',
				'table_item_color'               => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td,{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a',
				'table_item_bg_color'            => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td',
				// Button.
				'button_typography'              => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',
				'button_height'                  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',
				'button_width'                   => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',
				'button_text_color_normal'       => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',
				'button_bg_color_normal'         => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',
				'button_border'                  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',
				'button_text_color_hover'        => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button:hover',
				'button_bg_color_hover'          => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button:hover',
				'button_border_hover_color'      => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button:hover',
				'button_border_radius'           => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',
				'button_padding'                 => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',
				'button_margin'                  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-table--order-downloads tbody td a.button',

			],
			'rtsb-order-billing-address'   => [
				'show_title'         => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				// Title Style.
				'title_align'        => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_typo'         => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_color'        => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_text_stroke'  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_text_shadow'  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_margin'       => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_padding'      => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_border'       => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				// General Style.
				'content_align'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'content_bg_color'   => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'content_border'     => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'content_padding'    => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'address_typography' => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'address_color'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'contact_typography' => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address p',
				'contact_color'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address p',
			],
			'rtsb-order-shipping-address'  => [
				'show_title'         => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				// Title Style.
				'title_align'        => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_typo'         => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_color'        => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_text_stroke'  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_text_shadow'  => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_margin'       => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_padding'      => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_border'       => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				// General Style.
				'content_align'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'content_bg_color'   => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'content_border'     => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'content_padding'    => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'address_typography' => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'address_color'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address',
				'contact_typography' => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address p',
				'contact_color'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-order-thankyou.woocommerce-customer-details address p',
			],
			'rtsb-order-custom-field-data' => [
				'show_title'                 => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'section_gap'                => '{{WRAPPER}} .rtsb-custom-information-wrapper',
				'section_bg_color'           => '{{WRAPPER}} .rtsb-custom-information-wrapper .rtsb-order-info-table-wrapper',
				// Title Style.
				'title_align'                => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_typo'                 => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_color'                => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_text_stroke'          => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_text_shadow'          => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_margin'               => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_padding'              => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				'title_border'               => '{{WRAPPER}} .rtsb-order-thankyou .woocommerce-column__title',
				// Table.
				'table_border'               => '{{WRAPPER}} .rtsb-order-thankyou table :is(td, th)',
				'table_heading_cell_padding' => '{{WRAPPER}} .rtsb-order-thankyou table th',
				'table_header_typo'          => '{{WRAPPER}} .rtsb-order-thankyou table th',
				'table_header_align'         => '{{WRAPPER}} .rtsb-order-thankyou table th',
				'table_header_color'         => '{{WRAPPER}} .rtsb-order-thankyou table th',
				'table_header_bg_color'      => '{{WRAPPER}} .rtsb-order-thankyou table th',
				'table_item_typo'            => '{{WRAPPER}} .rtsb-order-thankyou table td',
				'table_item_align'           => '{{WRAPPER}} .rtsb-order-thankyou table td',
				'table_item_color'           => '{{WRAPPER}} .rtsb-order-thankyou table td',
				'table_item_bg_color'        => '{{WRAPPER}} .rtsb-order-thankyou table td',

			],
		];

		return apply_filters( 'rtsb/elements/elementor/widget/thankyou/selectors', $selectors );
	}

	/**
	 * Provides CSS selectors for styling the order payment form widget in Elementor.
	 *
	 * @since 1.0.0
	 *
	 * @return array CSS selectors grouped by setting keys.
	 *
	 * @hook rtsb/elements/elementor/widget/order_pay/selectors
	 */
	public static function order_pay_selectors() {
		$selectors = [
			'rtsb-order-pay-form' => [
				// Table.
				'table_heading_cell_border'             => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form  .shop_table td,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form  .shop_table th',
				'table_heading_cell_padding'            => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table :is(th, td)',
				'table_heading_typography'              => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:first-child, {{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:first-child strong,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-single-item .product-name,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-single-item .product-name a',
				'table_heading_color'                   => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:first-child,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:first-child a,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-single-item .product-name,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-single-item .product-name a',
				'table_heading_background_color'        => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:first-child,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-single-item',
				'table_heading_align'                   => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:first-child',
				'total_heading_width'                   => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table :is(th,td):first-child',
				'table_cell_typography'                 => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:nth-child(2), {{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:nth-child(2) strong,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-single-item .product-total,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order_item .product-subtotal,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .footer-item div',
				'table_cell_color'                      => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:nth-child(2),{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:nth-child(2) a,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-single-item .product-total,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .footer-item div,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order_item .product-subtotal',
				'table_cell_background_color'           => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:nth-child(2)',
				'table_cell_align'                      => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tbody td:nth-child(2),{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order_item .product-subtotal',
				'total_cell_heading_width'              => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table :is(th,td):nth-child(2)',
				'table_header_typo'                     => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table thead th',
				'table_header_align'                    => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table thead th',
				'table_header_color'                    => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table thead th,.rtsb-builder-content {{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-header div',
				'table_header_bg_color'                 => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table thead th,.rtsb-builder-content {{WRAPPER}}.elementor-widget-rtsb-order-pay-form .order-header',
				'table_footer_typo'                     => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tfoot :is( th, td ),{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .footer-item .label',
				'table_footer_align'                    => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tfoot :is( th, td )',
				'table_footer_color'                    => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tfoot :is( th, td ),{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .footer-item .label',
				'table_footer_bg_color'                 => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .shop_table tfoot :is( th, td ),{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .footer-item',

				// Payment method.
				'payment_method_wrapper_bg_color'       => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form  #payment',
				'wrapper_border_radius'                 => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form  #payment',
				'payment_link_color'                    => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form a',
				'payment_link_hover_color'              => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form a:hover',

				'payment_label_typography'              => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .wc_payment_method label',
				'payment_label_color'                   => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .wc_payment_method label, {{WRAPPER}} #payment .payment_methods li input[type=radio]:first-child+label:before',
				'payment_label_active_hover_color'      => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .wc_payment_method label:hover, {{WRAPPER}} #payment .payment_methods li input[type=radio]:first-child:checked+label:before, {{WRAPPER}} #payment .payment_methods li input[type=radio]:first-child:checked+label',
				'payment_label_bg_color'                => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .wc_payment_method label',
				'payment_method_space_between'          => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment ul.payment_methods li input',
				'payment_method_bacs_padding'           => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .payment_methods>.woocommerce-PaymentMethod>label,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .payment_methods>.wc_payment_method>label',
				'payment_method_wrap_padding'           => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment ul.payment_methods',
				'payment_method_bacs_margin'            => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form  #payment .payment_methods>.woocommerce-PaymentMethod>label,{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .payment_methods>.wc_payment_method>label',

				'payment_description_typography'        => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form p',
				'payment_description_text_color'        => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form p',
				'payment_description_bg_color'          => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .payment_methods > li .payment_box',
				'payment_description_border'            => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment ul.payment_methods',
				'payment_method_desc_padding'           => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .payment_methods li .payment_box',
				'payment_method_desc_margin'            => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .payment_methods li .payment_box',

				'payment_button_description_typography' => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .form-row p',
				'payment_button_description_text_color' => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .form-row  p',
				'payment_button_description_bg_color'   => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .form-row',
				'payment_button_wrapper_padding'        => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .form-row',
				'payment_button_wrapper_margin'         => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #payment .form-row',

				// Button section.
				'button_height'                         => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
				'button_width'                          => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
				'button_typography'                     => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
				'submit_button_alignment'               => [
					'text-align' => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .form-row #place_order',
					'float'      => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form .form-row #place_order',
				],
				'button_text_color_normal'              => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
				'button_bg_color_normal'                => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
				'button_border'                         => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
				'button_text_color_hover'               => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order:hover',
				'button_bg_color_hover'                 => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order:hover',
				'button_border_hover_color'             => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order:hover',
				'button_border_radius'                  => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
				'button_padding'                        => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
				'button_margin'                         => '{{WRAPPER}}.elementor-widget-rtsb-order-pay-form #place_order',
			],
		];
		return apply_filters( 'rtsb/elements/elementor/widget/order_pay/selectors', $selectors );
	}

	/**
	 * Checkout Page Widget List.
	 *
	 * @return array
	 */
	public static function my_account_page_selectors() {
		$selectors = [
			'rtsb-account-navigation'            => [
				'view_mode'                 => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul',
				'typography'                => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li',
				'navigation_border'         => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li',
				'active_text_decoration'    => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li.is-active a',
				'fields_border_color'       => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li',
				'fields_text_color'         => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li a,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li i',
				'fields_bg_color'           => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li a',
				'fields_hover_text_color'   => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li a:hover,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li.is-active a,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li.is-active .icon i,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li a:hover i,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li:hover i',
				'fields_hover_bg_color'     => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li a:hover,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li.is-active a',
				'fields_border_hover_color' => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li a:hover,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li.is-active',
				'gap'                       => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul',
				'content_padding'           => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li a',
				'border_radius'             => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li a',
				'icon_size'                 => [
					'svg'  => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li .icon svg',
					'icon' => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li i',
				],
				'icon_color'                => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li .icon svg,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li .icon svg path, .woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li .icon i',
				'icon_active_color'         => '.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li.is-active .icon svg,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li.is-active .icon svg path,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li:hover .icon svg,.woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li:hover .icon svg path, .woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li:hover .icon i, .woocommerce {{WRAPPER}} .rtsb-myacount-page .woocommerce-MyAccount-navigation ul li.is-active .icon i',
			],
			'rtsb-account-dashboard'             => [
				'text_typography'  => '.woocommerce {{WRAPPER}} .rtsb-myacount-page p',
				'text_color'       => '.woocommerce {{WRAPPER}} .rtsb-myacount-page p',
				'user_typography'  => '.woocommerce {{WRAPPER}} .rtsb-myacount-page p strong',
				'user_color'       => '.woocommerce {{WRAPPER}} .rtsb-myacount-page p strong',
				'link_typography'  => '.woocommerce {{WRAPPER}} .rtsb-myacount-page p a',
				'link_color'       => '.woocommerce {{WRAPPER}} .rtsb-myacount-page p a',
				'link_hover_color' => '.woocommerce {{WRAPPER}} .rtsb-myacount-page p a:hover',
			],
			'rtsb-account-orders'                => array_merge(
				ControlSelectors::button_settings_selector(),
				self::my_account_page_table_selectors()
			),
			'rtsb-account-download'              => array_merge(
				ControlSelectors::button_settings_selector(),
				self::my_account_page_table_selectors(),
				[
					'table_min_width'     => '.rtsb-builder-content {{WRAPPER}} .rtsb-table-horizontal-scroll-on-mobile table.shop_table',
					'striped_row_even_bg' => '{{WRAPPER}} .rtsb-myacount-page.has-striped-row table:not( .has-background ) tbody tr:nth-child(2n) td',
					'notice_typography'   => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner',
					'notice_padding'      => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner',
					'notice_bg_color'     => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner',
					'notice_text_color'   => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner',
					'notice_border_color' => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner',
					'icon_color'          => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner svg',
					'notice_icon_size'    => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner svg',
					'icon_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner svg',
					'icon_margin'         => '{{WRAPPER}} .rtsb-myacount-page .wc-block-components-notice-banner svg',

				]
			),
			'rtsb-account-billing-address'       => [
				'show_title'         => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				// Title Style.
				'title_align'        => '{{WRAPPER}} .rtsb-myacount-page.addresses .title',
				'title_typo'         => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_color'        => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_text_stroke'  => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_text_shadow'  => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_margin'       => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_padding'      => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_border'       => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				// General Style.
				'content_align'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'content_bg_color'   => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'content_border'     => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'content_padding'    => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'address_typography' => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'address_color'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'link_typography'    => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses .title a',
				'link_color'         => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses .title a',
				'link_hover_color'   => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses .title a:hover',

			],
			'rtsb-account-shipping-address'      => [
				'show_title'         => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				// Title Style.
				'title_align'        => '{{WRAPPER}} .rtsb-myacount-page.addresses .title',
				'title_typo'         => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_color'        => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_text_stroke'  => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_text_shadow'  => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_margin'       => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_padding'      => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				'title_border'       => '{{WRAPPER}} .rtsb-myacount-page.addresses .title h3',
				// General Style.
				'content_align'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'content_bg_color'   => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'content_border'     => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'content_padding'    => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'address_typography' => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'address_color'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses address',
				'link_typography'    => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses .title a',
				'link_color'         => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses .title a',
				'link_hover_color'   => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.addresses .title a:hover',

			],
			'rtsb-account-address-description'   => [
				'typo'        => '{{WRAPPER}} .rtsb-myacount-page.address-description p',
				'align'       => '{{WRAPPER}} .rtsb-myacount-page.address-description p',
				'text_color'  => '{{WRAPPER}} .rtsb-myacount-page.address-description p',
				'text_shadow' => '{{WRAPPER}} .rtsb-myacount-page.address-description p',

			],
			'rtsb-account-details'               => array_merge(
				ControlSelectors::button_settings_selector(),
				self::form_field_selectors(),
			),
			'rtsb-account-order-status'          => [
				'typo'          => '.woocommerce-view-order {{WRAPPER}} .rtsb-myacount-page p',
				'align'         => '.woocommerce-view-order {{WRAPPER}} .rtsb-myacount-page p',
				'text_color'    => '.woocommerce-view-order {{WRAPPER}} .rtsb-myacount-page p',
				'text_shadow'   => '.woocommerce-view-order {{WRAPPER}} .rtsb-myacount-page p',
				'mark_typo'     => '.woocommerce-view-order {{WRAPPER}} .rtsb-myacount-page p mark',
				'mark_color'    => '.woocommerce-view-order {{WRAPPER}} .rtsb-myacount-page p mark',
				'mark_bg_color' => '.woocommerce-view-order {{WRAPPER}} .rtsb-myacount-page p mark',
				'mark_padding'  => '.woocommerce-view-order {{WRAPPER}} .rtsb-myacount-page p mark',
			],
			'rtsb-account-order-download'        => array_merge(
				ControlSelectors::button_settings_selector(),
				self::my_account_page_title_selectors(),
				self::my_account_page_table_selectors(),
				[
					'table_min_width' => '.rtsb-builder-content {{WRAPPER}} .rtsb-table-horizontal-scroll-on-mobile table.shop_table',
				]
			),
			'rtsb-account-order-note'            => [
				// Title Style.
				'title_align'            => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_typo'             => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_color'            => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_text_stroke'      => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_text_shadow'      => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_margin'           => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_padding'          => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_border'           => '{{WRAPPER}} .rtsb-myacount-page h2',
				// Content Style.
				'content_margin'         => '{{WRAPPER}} .rtsb-myacount-page .notes',
				'list_gap'               => '{{WRAPPER}} .rtsb-myacount-page .notes li',
				'meta_typography'        => '{{WRAPPER}} .rtsb-myacount-page .notes .meta',
				'meta_color'             => '{{WRAPPER}} .rtsb-myacount-page .notes .meta',
				'meta_margin'            => '{{WRAPPER}} .rtsb-myacount-page .notes .meta',
				'description_typography' => '{{WRAPPER}} .rtsb-myacount-page .notes .description ',
				'description_color'      => '{{WRAPPER}} .rtsb-myacount-page .notes .description',
			],
			'rtsb-account-order-table'           => [
				// Title Style.
				'title_align'                    => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details__title',
				'table_min_width'                => '',
				'title_typo'                     => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details__title',
				'title_color'                    => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details__title',
				'title_text_stroke'              => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details__title',
				'title_text_shadow'              => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details__title',
				'title_margin'                   => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details__title',
				'title_padding'                  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details__title',
				'title_border'                   => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-order-details__title',
				// Table.
				'table_heading_cell_border'      => '{{WRAPPER}} .rtsb-myacount-page  .shop_table,{{WRAPPER}} .rtsb-myacount-page  .shop_table td,{{WRAPPER}} .rtsb-myacount-page  .shop_table th',
				'table_heading_cell_padding'     => '{{WRAPPER}} .rtsb-myacount-page .shop_table th,{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td, {{WRAPPER}} .rtsb-myacount-page .shop_table tfoot td',
				'table_heading_typography'       => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:first-child, {{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:first-child strong',
				'table_heading_color'            => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:first-child,{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:first-child a',
				'table_heading_background_color' => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:first-child',
				'table_heading_align'            => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:first-child',
				'total_heading_width'            => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:first-child',
				'table_cell_typography'          => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:nth-child(2), {{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:nth-child(2) strong',
				'table_cell_color'               => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:nth-child(2),{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:nth-child(2) a',
				'table_cell_background_color'    => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:nth-child(2)',
				'table_cell_align'               => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:nth-child(2)',
				'total_cell_heading_width'       => '{{WRAPPER}} .rtsb-myacount-page .shop_table tbody td:nth-child(2)',
				'table_header_typo'              => '{{WRAPPER}} .rtsb-myacount-page .shop_table thead th',
				'table_header_align'             => '{{WRAPPER}} .rtsb-myacount-page .shop_table thead th',
				'table_header_color'             => '{{WRAPPER}} .rtsb-myacount-page .shop_table thead th',
				'table_header_bg_color'          => '{{WRAPPER}} .rtsb-myacount-page .shop_table thead th',
				'table_footer_typo'              => '{{WRAPPER}} .rtsb-myacount-page .shop_table tfoot th,{{WRAPPER}} .rtsb-myacount-page .shop_table tfoot td',
				'table_footer_align'             => '{{WRAPPER}} .rtsb-myacount-page .shop_table tfoot th,{{WRAPPER}} .rtsb-myacount-page .shop_table tfoot td',
				'table_footer_color'             => '{{WRAPPER}} .rtsb-myacount-page .shop_table tfoot th,{{WRAPPER}} .rtsb-myacount-page .shop_table tfoot td',
				'table_footer_bg_color'          => '{{WRAPPER}} .rtsb-myacount-page .shop_table tfoot th,{{WRAPPER}} .rtsb-myacount-page .shop_table tfoot td',
				// Button.
				'button_typography'              => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
				'button_height'                  => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
				'button_width'                   => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
				'button_text_color_normal'       => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
				'button_bg_color_normal'         => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
				'button_border'                  => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
				'button_text_color_hover'        => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button:hover',
				'button_bg_color_hover'          => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button:hover',
				'button_border_hover_color'      => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button:hover',
				'button_border_radius'           => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
				'button_padding'                 => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
				'button_margin'                  => '{{WRAPPER}} .rtsb-myacount-page .order-actions a.button',
			],
			'rtsb-account-order-again'           => [
				// Button.
				'button_typography'         => '{{WRAPPER}} .rtsb-myacount-page  a.button',
				'button_height'             => '{{WRAPPER}} .rtsb-myacount-page  a.button',
				'button_width'              => '{{WRAPPER}} .rtsb-myacount-page  a.button',
				'button_text_color_normal'  => '{{WRAPPER}} .rtsb-myacount-page  a.button',
				'button_bg_color_normal'    => '{{WRAPPER}} .rtsb-myacount-page  a.button',
				'button_border'             => '{{WRAPPER}} .rtsb-myacount-page  a.button',
				'button_text_color_hover'   => '{{WRAPPER}} .rtsb-myacount-page  a.button:hover',
				'button_bg_color_hover'     => '{{WRAPPER}} .rtsb-myacount-page  a.button:hover',
				'button_border_hover_color' => '{{WRAPPER}} .rtsb-myacount-page  a.button:hover',
				'button_border_radius'      => '{{WRAPPER}} .rtsb-myacount-page  a.button',
				'button_padding'            => '{{WRAPPER}} .rtsb-myacount-page  a.button',
				'button_margin'             => '{{WRAPPER}} .rtsb-myacount-page  a.button',
			],
			'rtsb-account-order-shipping'        => [
				'show_title'         => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				// Title Style.
				'title_align'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_typo'         => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_color'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_text_stroke'  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_text_shadow'  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_margin'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_padding'      => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_border'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				// General Style.
				'content_align'      => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'content_bg_color'   => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'content_border'     => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'content_padding'    => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'address_typography' => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'address_color'      => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
			],
			'rtsb-account-order-billing'         => [
				'show_title'         => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				// Title Style.
				'title_align'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_typo'         => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_color'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_text_stroke'  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_text_shadow'  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_margin'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_padding'      => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				'title_border'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-column__title',
				// General Style.
				'content_align'      => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'content_bg_color'   => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'content_border'     => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'content_padding'    => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'address_typography' => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'address_color'      => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address',
				'contact_typography' => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address p',
				'contact_color'      => '{{WRAPPER}} .rtsb-myacount-page.woocommerce-customer-details address p',
			],
			'rtsb-account-login'                 => [
				// Title Style.
				'title_align'                 => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_typo'                  => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_color'                 => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_text_stroke'           => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_text_shadow'           => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_margin'                => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_padding'               => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_border'                => '{{WRAPPER}} .rtsb-myacount-page h2',
				// wrapper.
				'form_wrapper_border'         => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_border_between_color'   => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .rtsb-left-border::before',
				'form_wrapper_border_radius'  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_wrapper_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_wrapper_padding'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				// Text.
				'typo'                        => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-privacy-policy-text p, {{WRAPPER}} .woocommerce-form-register .link',
				'align'                       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p,{{WRAPPER}} .rtsb-myacount-page .lost_password a,{{WRAPPER}} .woocommerce-form-register .link',
				'text_color'                  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p,{{WRAPPER}} .rtsb-myacount-page .lost_password a,{{WRAPPER}} .woocommerce-form-register .link',
				'text_shadow'                 => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p,{{WRAPPER}} .rtsb-myacount-page .lost_password a,{{WRAPPER}} .woocommerce-form-register .link',
				'form_link_text_color'        => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .woocommerce-form-register .woocommerce-privacy-policy-text a',
				'form_link_text_hover_color'  => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .woocommerce-form-register .woocommerce-privacy-policy-text a:hover',
				'text_margin'                 => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p, {{WRAPPER}} .woocommerce-form-register .link',
				// Lost Password.
				'lost_pass_typography'        => '{{WRAPPER}} .rtsb-myacount-page .lost_password a',
				'lost_pass_color'             => '{{WRAPPER}} .rtsb-myacount-page .lost_password a',
				'lost_pass_hover_color'       => '{{WRAPPER}} .rtsb-myacount-page .lost_password a:hover',
				'lost_pass_margin'            => '{{WRAPPER}} .rtsb-myacount-page .lost_password a',
				// Label.
				'fields_label_typo'           => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_color'          => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_reguired_color' => '{{WRAPPER}} .rtsb-myacount-page form label .required',
				'fields_label_margin'         => '{{WRAPPER}} .rtsb-myacount-page form label',
				// Input Fields.
				'fields_height'               => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border'               => '{{WRAPPER}} .rtsb-myacount-page input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_text_color'           => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select,{{WRAPPER}} .rtsb-myacount-page form span em',
				'fields_bg_color'             => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				// Hover.
				'fields_hover_border'         => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_border_radius_hover'  => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_hover_text_color'     => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} , {{WRAPPER}} .rtsb-myacount-page form.select2-container--open .select2-selection--single,{{WRAPPER}} .rtsb-myacount-page form span em:is(:hover)',
				'fields_hover_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single',
				'form_heading_typo'           => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_color'          => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_gap'            => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_row_margin'             => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form .form-row',
				'fields_padding'              => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]),{{WRAPPER}} .rtsb-myacount-page form .select2-container--default .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form :is( select, .select2-selection--single )',
				// Button.
				'button_typography'           => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_height'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_width'                => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_normal'    => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_bg_color_normal'      => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_border'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_hover'     => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_bg_color_hover'       => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_hover_color'   => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_padding'              => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_margin'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
			],
			'rtsb-account-lost-password'         => [
				// wrapper.
				'form_wrapper_border'         => '{{WRAPPER}} .rtsb-myacount-page .lost_reset_password',
				'form_wrapper_border_radius'  => '{{WRAPPER}} .rtsb-myacount-page .lost_reset_password',
				'form_wrapper_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page .lost_reset_password',
				'form_wrapper_padding'        => '{{WRAPPER}} .rtsb-myacount-page .lost_reset_password',
				// Text.
				'typo'                        => '{{WRAPPER}} .rtsb-myacount-page  .info-text',
				'align'                       => '{{WRAPPER}} .rtsb-myacount-page  .info-text',
				'text_color'                  => '{{WRAPPER}} .rtsb-myacount-page .info-text',
				'text_shadow'                 => '{{WRAPPER}} .rtsb-myacount-page  .info-text',
				'form_link_text_color'        => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .woocommerce-form-register .woocommerce-privacy-policy-text a',
				'form_link_text_hover_color'  => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .woocommerce-form-register .woocommerce-privacy-policy-text a:hover',
				'text_margin'                 => '{{WRAPPER}} .rtsb-myacount-page .info-text',
				// Label.
				'fields_label_typo'           => '{{WRAPPER}} .rtsb-myacount-page .lost_reset_password label',
				'fields_label_color'          => '{{WRAPPER}} .rtsb-myacount-page .lost_reset_password label',
				'fields_label_reguired_color' => '{{WRAPPER}} .rtsb-myacount-page form label .required',
				'fields_label_margin'         => '{{WRAPPER}} .rtsb-myacount-page .lost_reset_password label',
				// Input Fields.
				'fields_height'               => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border'               => '{{WRAPPER}} .rtsb-myacount-page input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_text_color'           => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select,{{WRAPPER}} .rtsb-myacount-page form span em',
				'fields_bg_color'             => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				// Hover.
				'fields_hover_border'         => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_border_radius_hover'  => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_hover_text_color'     => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} , {{WRAPPER}} .rtsb-myacount-page form.select2-container--open .select2-selection--single,{{WRAPPER}} .rtsb-myacount-page form span em:is(:hover)',
				'fields_hover_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single',
				'form_heading_typo'           => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_color'          => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_row_margin'             => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_gap'            => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'fields_padding'              => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]),{{WRAPPER}} .rtsb-myacount-page form .select2-container--default .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form :is( select, .select2-selection--single )',
				// Button.
				'button_typography'           => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_height'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_width'                => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_normal'    => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_bg_color_normal'      => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_border'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_hover'     => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_bg_color_hover'       => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_hover_color'   => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_padding'              => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_margin'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				// Info Box.
				'info_box_typo'               => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-message',
				'info_box_border'             => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-message',
				'info_box_border_radius'      => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-message',
				'info_box_bg_color'           => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-message',
				'info_box_padding'            => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-message',

			],
			'rtsb-account-edit-billing-address'  => [
				// Title.
				'show_title'                  => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_align'                 => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_typo'                  => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_color'                 => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_text_stroke'           => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_text_shadow'           => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_margin'                => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_padding'               => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_border'                => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				// Label.
				'fields_label_typo'           => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_color'          => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_reguired_color' => '{{WRAPPER}} .rtsb-myacount-page form label .required',
				'fields_label_margin'         => '{{WRAPPER}} .rtsb-myacount-page form label',
				// Input Fields.
				'fields_height'               => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border'               => '{{WRAPPER}} .rtsb-myacount-page input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_text_color'           => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select,{{WRAPPER}} .rtsb-myacount-page form span em',
				'fields_bg_color'             => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				// Hover.
				'fields_hover_border'         => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_border_radius_hover'  => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_hover_text_color'     => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} , {{WRAPPER}} .rtsb-myacount-page form.select2-container--open .select2-selection--single,{{WRAPPER}} .rtsb-myacount-page form span em:is(:hover)',
				'fields_hover_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single',
				'form_heading_typo'           => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_color'          => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_gap'            => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_row_margin'             => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-address-fields .form-row',
				'fields_padding'              => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]),{{WRAPPER}} .rtsb-myacount-page form .select2-container--default .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form :is( select, .select2-selection--single )',
				// Button.
				'button_typography'           => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_height'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_width'                => '{{WRAPPER}} .rtsb-myacount-page  .button',

				'button_text_color_normal'    => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_bg_color_normal'      => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_border'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_hover'     => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_bg_color_hover'       => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_hover_color'   => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_padding'              => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_margin'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
			],
			'rtsb-account-edit-shipping-address' => [
				// Title.
				'show_title'                  => '.rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'table_min_width'             => '',
				'title_align'                 => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_typo'                  => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_color'                 => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_text_stroke'           => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_text_shadow'           => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_margin'                => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_padding'               => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				'title_border'                => '{{WRAPPER}} .rtsb-myacount-page.edit-address form h3',
				// Label.
				'fields_label_typo'           => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_color'          => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_reguired_color' => '{{WRAPPER}} .rtsb-myacount-page form label .required',
				'fields_label_margin'         => '{{WRAPPER}} .rtsb-myacount-page form label',
				// Input Fields.
				'fields_height'               => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border'               => '{{WRAPPER}} .rtsb-myacount-page input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_text_color'           => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select,{{WRAPPER}} .rtsb-myacount-page form span em',
				'fields_bg_color'             => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				// Hover.
				'fields_hover_border'         => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_border_radius_hover'  => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_hover_text_color'     => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} , {{WRAPPER}} .rtsb-myacount-page form.select2-container--open .select2-selection--single,{{WRAPPER}} .rtsb-myacount-page form span em:is(:hover)',
				'fields_hover_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single',
				'form_heading_typo'           => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_color'          => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_gap'            => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_row_margin'             => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-address-fields .form-row',
				'fields_padding'              => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]),{{WRAPPER}} .rtsb-myacount-page form .select2-container--default .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form :is( select, .select2-selection--single )',
				// Button.
				'button_typography'           => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_height'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_width'                => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_normal'    => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_bg_color_normal'      => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_border'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_hover'     => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_bg_color_hover'       => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_hover_color'   => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_padding'              => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_margin'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
			],
			'rtsb-account-login-form'            => [
				// Title Style.
				'title_align'                 => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_typo'                  => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_color'                 => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_text_stroke'           => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_text_shadow'           => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_margin'                => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_padding'               => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_border'                => '{{WRAPPER}} .rtsb-myacount-page h2',
				// wrapper.
				'form_wrapper_border'         => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_border_between_color'   => '.woocommerce-account .rtsb-builder-content {{WRAPPER}} .rtsb-myacount-page .rtsb-left-border::before',
				'form_wrapper_border_radius'  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_wrapper_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_wrapper_padding'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				// Text.
				'typo'                        => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-privacy-policy-text p',
				'align'                       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p',
				'text_color'                  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p',
				'text_shadow'                 => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p',
				'form_link_text_color'        => '',
				'form_link_text_hover_color'  => '',
				'text_margin'                 => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p',

				// Lost Password.
				'lost_pass_typography'        => '{{WRAPPER}} .rtsb-myacount-page .lost_password a',
				'lost_pass_color'             => '{{WRAPPER}} .rtsb-myacount-page .lost_password a',
				'lost_pass_hover_color'       => '{{WRAPPER}} .rtsb-myacount-page .lost_password a:hover',
				'lost_pass_margin'            => '{{WRAPPER}} .rtsb-myacount-page .lost_password a',

				// Label.
				'fields_label_typo'           => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_color'          => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_reguired_color' => '{{WRAPPER}} .rtsb-myacount-page form label .required',
				'fields_label_margin'         => '{{WRAPPER}} .rtsb-myacount-page form label',
				// Input Fields.
				'fields_height'               => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border'               => '{{WRAPPER}} .rtsb-myacount-page input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_text_color'           => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select,{{WRAPPER}} .rtsb-myacount-page form span em',
				'fields_bg_color'             => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				// Hover.
				'fields_hover_border'         => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_border_radius_hover'  => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_hover_text_color'     => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} , {{WRAPPER}} .rtsb-myacount-page form.select2-container--open .select2-selection--single,{{WRAPPER}} .rtsb-myacount-page form span em:is(:hover)',
				'fields_hover_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single',
				'form_heading_typo'           => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_color'          => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_gap'            => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_row_margin'             => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form .form-row',
				'fields_padding'              => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]),{{WRAPPER}} .rtsb-myacount-page form .select2-container--default .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form :is( select, .select2-selection--single )',
				// Button.
				'button_typography'           => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_height'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_width'                => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_normal'    => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_bg_color_normal'      => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_border'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_hover'     => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_bg_color_hover'       => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_hover_color'   => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_padding'              => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_margin'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
			],
			'rtsb-account-registration-form'     => [
				// Title Style.
				'title_align'                 => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_typo'                  => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_color'                 => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_text_stroke'           => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_text_shadow'           => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_margin'                => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_padding'               => '{{WRAPPER}} .rtsb-myacount-page h2',
				'title_border'                => '{{WRAPPER}} .rtsb-myacount-page h2',
				// wrapper.
				'form_wrapper_border'         => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_border_between_color'   => '',
				'form_wrapper_border_radius'  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_wrapper_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				'form_wrapper_padding'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form',
				// Text.
				'typo'                        => '{{WRAPPER}} .rtsb-myacount-page  .woocommerce-privacy-policy-text p,{{WRAPPER}} .woocommerce-form-register .link',
				'align'                       => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p,{{WRAPPER}} .woocommerce-form-register .link',
				'text_color'                  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p,{{WRAPPER}} .woocommerce-form-register .link',
				'text_shadow'                 => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p,{{WRAPPER}} .woocommerce-form-register .link',
				'form_link_text_color'        => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text .woocommerce-privacy-policy-link',
				'form_link_text_hover_color'  => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text .woocommerce-privacy-policy-link:hover',
				'text_margin'                 => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-privacy-policy-text p',

				// Lost Password.
				'lost_pass_typography'        => '',
				'lost_pass_color'             => '',
				'lost_pass_hover_color'       => '',
				'lost_pass_margin'            => '',

				// Label.
				'fields_label_typo'           => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_color'          => '{{WRAPPER}} .rtsb-myacount-page form label',
				'fields_label_reguired_color' => '{{WRAPPER}} .rtsb-myacount-page form label .required',
				'fields_label_margin'         => '{{WRAPPER}} .rtsb-myacount-page form label',
				// Input Fields.
				'fields_height'               => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border'               => '{{WRAPPER}} .rtsb-myacount-page input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				'fields_text_color'           => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select,{{WRAPPER}} .rtsb-myacount-page form span em',
				'fields_bg_color'             => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]), {{WRAPPER}} .rtsb-myacount-page form .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select',
				// Hover.
				'fields_hover_border'         => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_border_radius_hover'  => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form select:is(:hover, :focus, :active,:focus-visible)',
				'fields_hover_text_color'     => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} , {{WRAPPER}} .rtsb-myacount-page form.select2-container--open .select2-selection--single,{{WRAPPER}} .rtsb-myacount-page form span em:is(:hover)',
				'fields_hover_bg_color'       => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtsb-myacount-page form .select2-container--open .select2-selection--single',
				'form_heading_typo'           => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_color'          => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_heading_gap'            => '{{WRAPPER}} .rtsb-myacount-page form legend',
				'form_row_margin'             => '{{WRAPPER}} .rtsb-myacount-page .woocommerce-form .form-row',
				'fields_padding'              => '{{WRAPPER}} .rtsb-myacount-page form input:not([type=checkbox],[type=radio]),{{WRAPPER}} .rtsb-myacount-page form .select2-container--default .select2-selection--single, {{WRAPPER}} .rtsb-myacount-page form :is( select, .select2-selection--single )',
				// Button.
				'button_typography'           => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_height'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_width'                => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_normal'    => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_bg_color_normal'      => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_border'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_text_color_hover'     => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_bg_color_hover'       => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_hover_color'   => '{{WRAPPER}} .rtsb-myacount-page  .button:hover',
				'button_border_radius'        => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_padding'              => '{{WRAPPER}} .rtsb-myacount-page  .button',
				'button_margin'               => '{{WRAPPER}} .rtsb-myacount-page  .button',
			],
		];

		return apply_filters( 'rtsb/elements/elementor/widget/my_account/selectors', $selectors );
	}

	/**
	 * Pro Common Style Controls.
	 *
	 * @param array $selectors Selectors.
	 *
	 * @return array
	 */
	public static function pro_common_selectors( $selectors ) {
		$pro_selectors = [
			'ajax_filter_controls'  => [
				'typography'               => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item',
				'alignment'                => '{{WRAPPER}} .rtsb-elementor-container .rtsb-tab-filters',
				'track_height'             => '{{WRAPPER}} .rtsb-filter-item-wrap.rtsb-tax-filter.type-track .rtsb-tracks-wrapper',
				'color'                    => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item',
				'count_color'              => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-count',
				'track_bg_color'           => '{{WRAPPER}} .rtsb-filter-item-wrap.rtsb-tax-filter.type-track .rtsb-tracks-wrapper',
				'track_border_color'       => '{{WRAPPER}} .rtsb-filter-item-wrap.rtsb-tax-filter.type-track',
				'bg_color'                 => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item',
				'hover_color'              => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item:hover',
				'count_hover_color'        => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item:hover .rtsb-count',
				'track_bg_hover_color'     => '{{WRAPPER}} .rtsb-filter-item-wrap.rtsb-tax-filter.type-track:hover .rtsb-tracks-wrapper',
				'track_border_hover_color' => '{{WRAPPER}} .rtsb-filter-item-wrap.rtsb-tax-filter.type-track:hover',
				'hover_bg_color'           => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item:hover',
				'active_color'             => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item.selected',
				'active_count_color'       => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item.selected .rtsb-count',
				'active_bg_color'          => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item.selected, {{WRAPPER}} .rtsb-filter-item-wrap.rtsb-tax-filter.type-track .rtsb-tracks-wrapper .rtsb-filter-item-track',
				'border'                   => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item',
				'border_hover_color'       => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item:hover',
				'border_active_color'      => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item.selected',
				'border_radius'            => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item',
				'padding'                  => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item',
				'margin'                   => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter .rtsb-filter-button-item',
				'wrapper_margin'           => '{{WRAPPER}} .rtsb-elementor-container .rtsb-filter-item-wrap.rtsb-tax-filter',
			],
			'quick_checkout_styles' => [
				'typography'            => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
				'icon_size'             => [
					'font_size' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn .icon',
					'width'     => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn .icon svg',
				],
				'checkout_icon_spacing' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn .icon + .text',
				'checkout_width'        => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
				'checkout_height'       => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
				'color'                 => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
				'bg_color'              => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
				'icon_color'            => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn .icon',
				'hover_color'           => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn:hover',
				'hover_bg_color'        => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn:hover',
				'hover_icon_color'      => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn:hover .icon',
				'border'                => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
				'border_hover_color'    => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn:hover',
				'border_radius'         => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
				'padding'               => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
				'margin'                => '{{WRAPPER}} .rtsb-elementor-container .rtsb-quick-checkout .rtsb-action-btn',
			],
			/**
				'badges_module'         => [
					'direction' => '{{WRAPPER}} .rtsb-promotion .rtsb-badge-group-style',
					'alignment' => '{{WRAPPER}} .rtsb-promotion .rtsb-badge-group-style',
				],
			*/
			'full_product_height'   => '{{WRAPPER}} .rtsb-elementor-container.full-product-column-right.products-per-column-3.products-layout-7 .rtsb-grid-layout9 .rtsb-product:nth-child(7) .rtsb-product-img .rtsb-product-image, {{WRAPPER}} .rtsb-elementor-container.full-product-column-right.products-per-column-3 .rtsb-grid-layout9 .rtsb-product:nth-child(13) .rtsb-product-img .rtsb-product-image, {{WRAPPER}} .rtsb-elementor-container.full-product-column-right.products-per-column-2.products-layout-5 .rtsb-grid-layout9 .rtsb-product:nth-child(5) .rtsb-product-img .rtsb-product-image, {{WRAPPER}} .rtsb-elementor-container.full-product-column-right.products-per-column-2 .rtsb-grid-layout9 .rtsb-product:nth-child(9) .rtsb-product-img .rtsb-product-image, {{WRAPPER}} .rtsb-elementor-container.full-product-column-center.products-per-column-3.products-layout-7 .rtsb-grid-layout9 .rtsb-product:nth-child(4) .rtsb-product-img .rtsb-product-image, {{WRAPPER}} .rtsb-elementor-container.full-product-column-center.products-per-column-3 .rtsb-grid-layout9 .rtsb-product:nth-child(7) .rtsb-product-img .rtsb-product-image, {{WRAPPER}} .rtsb-elementor-container.full-product-column-center.products-per-column-2 .rtsb-grid-layout9 .rtsb-product:nth-child(3) .rtsb-product-img .rtsb-product-image, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout9 .rtsb-product:first-child .rtsb-product-img .rtsb-product-image',
		];

		return array_merge( $selectors, $pro_selectors );
	}

	/**
	 * Pro Product Style Controls.
	 *
	 * @param array $selectors Selectors.
	 *
	 * @return array
	 */
	public static function pro_product_selectors( $selectors ) {
		// Rating.
		$selectors['product_rating']['rating_bg']          = '{{WRAPPER}} .product-rating.preset2 .inner-wrapper';
		$selectors['product_rating']['star_border_radius'] = '{{WRAPPER}} .product-rating.preset2 .inner-wrapper';
		$selectors['product_rating']['star_padding']       = '{{WRAPPER}} .product-rating.preset2 .inner-wrapper';
		$selectors['product_rating']['typography']        .= ', {{WRAPPER}} .product-rating.preset2 .inner-wrapper';
		$selectors['product_rating']['color']             .= ', {{WRAPPER}} .product-rating.preset2 .inner-wrapper';

		// Add to cart.
		$selectors['product_add_to_cart']['typography']         .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-list-layout4 .rtsb-product .rtsb-list-item .rtsb-content-footer .rtsb-action-buttons .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout5 .rtsb-product .product-price-with-cart .rtsb-action-buttons.add-to-cart-action .rtsb-action-btn,{{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-product .product-price-with-cart .rtsb-action-buttons.add-to-cart-action .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout9 .rtsb-product .product-price-with-cart .rtsb-action-buttons.add-to-cart-action .rtsb-action-btn';
		$selectors['product_add_to_cart']['color']              .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout5 .rtsb-product .product-price-with-cart .rtsb-cart .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout9 .rtsb-product .product-price-with-cart .rtsb-cart .rtsb-action-btn';
		$selectors['product_add_to_cart']['bg_color']           .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout5 .rtsb-product .product-price-with-cart .rtsb-cart .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout9 .rtsb-product .product-price-with-cart .rtsb-cart .rtsb-action-btn';
		$selectors['product_add_to_cart']['icon_color']         .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn i, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn i';
		$selectors['product_add_to_cart']['hover_color']        .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn:hover, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn:hover, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout5 .rtsb-product .product-price-with-cart .rtsb-cart .rtsb-action-btn:hover, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout9 .rtsb-product .product-price-with-cart .rtsb-cart .rtsb-action-btn:hover';
		$selectors['product_add_to_cart']['hover_bg_color']     .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn:hover, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn:hover, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout5 .rtsb-product .product-price-with-cart .rtsb-cart .rtsb-action-btn:hover, {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout9 .rtsb-product .product-price-with-cart .rtsb-cart .rtsb-action-btn:hover';
		$selectors['product_add_to_cart']['hover_icon_color']   .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn:hover i, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout6 .rtsb-product .rtsb-cart .rtsb-action-btn:hover i';
		$selectors['product_add_to_cart']['border']             .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-action-buttons .rtsb-cart .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout6 .rtsb-action-buttons .rtsb-cart .rtsb-action-btn';
		$selectors['product_add_to_cart']['border_hover_color'] .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout6 .rtsb-action-buttons .rtsb-cart .rtsb-action-btn:hover, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout6 .rtsb-action-buttons .rtsb-cart .rtsb-action-btn:hover';
		$selectors['product_compare']['border']                 .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-list-layout4 .rtsb-product .rtsb-list-item .rtsb-action-buttons.top-part .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout5 .rtsb-product .rtsb-list-item .rtsb-action-buttons.top-part .rtsb-action-btn';
		$selectors['product_wishlist']['border']                .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-list-layout4 .rtsb-product .rtsb-list-item .rtsb-action-buttons.top-part .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout5 .rtsb-product .rtsb-list-item .rtsb-action-buttons.top-part .rtsb-action-btn';
		$selectors['product_quick_view']['border']              .= ', {{WRAPPER}} .rtsb-elementor-container .rtsb-list-layout4 .rtsb-product .rtsb-list-item .rtsb-action-buttons.top-part .rtsb-action-btn, {{WRAPPER}} .rtsb-elementor-container .rtsb-slider-layout5 .rtsb-product .rtsb-list-item .rtsb-action-buttons.top-part .rtsb-action-btn';

		return $selectors;
	}

	/**
	 * Product Filters Style Controls.
	 *
	 * @return array
	 */
	public static function product_filters_selectors() {
		return [
			'rtsb-ajax-product-filters' => [
				'layout'         => [
					'columns'           => '{{WRAPPER}} .rtsb-archive-filters-wrapper.horizontal-layout .rtsb-archive-filters-inner',
					'container'         => '{{WRAPPER}} .rtsb-archive-filters-wrapper.horizontal-layout.has-floating .filter-content',
					'inner_container'   => '{{WRAPPER}} .rtsb-archive-filters-wrapper.horizontal-layout.has-floating .rtsb-product-filters > .filter-content > ul',
					'columns_gap'       => '{{WRAPPER}} .rtsb-archive-filters-wrapper.horizontal-layout .rtsb-archive-filters-inner',
					'columns_alignment' => '{{WRAPPER}} .rtsb-archive-filters-wrapper.horizontal-layout .rtsb-archive-filters-inner',
					'canvas_width'      => '{{WRAPPER}} .rtsb-archive-filters-wrapper.horizontal-layout.has-floating .filter-content',
					'canvas_alignment'  => '{{WRAPPER}} .rtsb-archive-filters-wrapper.horizontal-layout.has-floating .filter-content',
					'mobile_breakpoint' => '{{WRAPPER}} .rtsb-archive-filters-wrapper',
				],
				'filter_types'   => [
					'column_gap' => '{{WRAPPER}} .rtsb-product-filters .filter-content.col-c2 .product-filters, {{WRAPPER}} .rtsb-product-filters .filter-content.col-auto .product-filters',
				],
				'color_scheme'   => [
					'primary_color'   => '{{WRAPPER}} .rtsb-archive-filters',
					'secondary_color' => '{{WRAPPER}} .rtsb-archive-filters',
				],
				'filter_header'  => [
					'typography' => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-header h3',
					'alignment'  => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-header h3',
					'color'      => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-header h3',
					'bg_color'   => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-header h3',
					'padding'    => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-header h3',
					'border'     => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-header h3',
					'margin'     => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-header h3',
				],
				'filter_title'   => [
					'typography'             => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper .widget-title, {{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .widget-title',
					'icon_size'              => '{{WRAPPER}} .rtsb-product-filters .widget-title .filter-title-icon, {{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .widget-title .filter-title-icon',
					'collapse_icon_size'     => '{{WRAPPER}} .rtsb-archive-filters-wrapper.has-collapse .filter-title-wrapper.left h3::before, {{WRAPPER}} .rtsb-archive-filters-wrapper.has-collapse .filter-title-wrapper.left h3::after, {{WRAPPER}} .rtsb-archive-filters-wrapper.has-collapse .filter-title-wrapper.right::before, {{WRAPPER}} .rtsb-archive-filters-wrapper.has-collapse .filter-title-wrapper.right::after',
					'collapse_icon_position' => '{{WRAPPER}} .rtsb-archive-filters-wrapper .filter-title-wrapper.right::before, {{WRAPPER}} .rtsb-archive-filters-wrapper .filter-title-wrapper.right::after',
					'alignment'              => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper .widget-title, {{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .widget-title',
					'color'                  => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper .widget-title, {{WRAPPER}} .rtsb-archive-filters-wrapper .rtsb-product-filters .filter-title-wrapper i, {{WRAPPER}} .rtsb-product-search .filter-title-wrapper .widget-title, {{WRAPPER}} .rtsb-archive-filters-wrapper .rtsb-product-search .filter-title-wrapper i',
					'bg_color'               => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper, {{WRAPPER}} .rtsb-product-search .filter-title-wrapper',
					'hover_color'            => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper:hover .widget-title, {{WRAPPER}} .rtsb-archive-filters-wrapper .rtsb-product-filters .filter-title-wrapper:hover i, {{WRAPPER}} .rtsb-product-search .filter-title-wrapper:hover .widget-title, {{WRAPPER}} .rtsb-archive-filters-wrapper .rtsb-product-search .filter-title-wrapper:hover i',
					'hover_bg_color'         => '{{WRAPPER}} .rtsb-product-search .filter-title-wrapper:hover, {{WRAPPER}} .rtsb-product-filters .filter-title-wrapper:hover',
					'title_active_color'     => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper.active h3, {{WRAPPER}} .rtsb-archive-filters-wrapper .filter-title-wrapper.active:before, {{WRAPPER}} .rtsb-archive-filters-wrapper .filter-title-wrapper.active:after',
					'title_active_bg_color'  => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper.active',
					'border'                 => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper, {{WRAPPER}} .rtsb-product-search .filter-title-wrapper',
					'border_hover_color'     => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper:hover, {{WRAPPER}} .rtsb-product-search .filter-title-wrapper:hover',
					'padding'                => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper',
					'active_padding'         => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper.active',
					'margin'                 => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper',
					'icon_margin'            => '{{WRAPPER}} .rtsb-product-filters .filter-title-wrapper .widget-title .filter-title-icon, {{WRAPPER}} .rtsb-product-search .filter-title-wrapper .widget-title .filter-title-icon',
					'border_radius'          => '{{WRAPPER}} .rtsb-archive-filters-wrapper .rtsb-product-filters, {{WRAPPER}} .rtsb-product-filters .filter-title-wrapper, {{WRAPPER}} .rtsb-product-search .filter-title-wrapper',
				],
				'filter_items'   => [
					'typography'          => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label, {{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter + label, {{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-color-filter .filter-attr-name, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter .filter-attr-name, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters .filter-content .more-less-button, {{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-rating-star-wrapper + .rtsb-count',
					'count_display'       => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group .rtsb-count',
					'count_alignment'     => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group',
					'color'               => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-color-filter, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter',
					'bg_color'            => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group',
					'count_color'         => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-rating-star-wrapper + .rtsb-count',
					'hover_color'         => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-checkbox-filter + label, {{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group:hover .rtsb-count, {{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-radio-filter + label, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group:hover .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group:hover .rtsb-color-filter .filter-attr-name, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group:hover .rtsb-color-filter .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group:hover .rtsb-button-filter .filter-attr-name, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group:hover .rtsb-button-filter .rtsb-count',
					'hover_bg_color'      => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-term-item .rtsb-filter-group:hover, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-term-item .rtsb-filter-group:hover, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group:hover, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group:hover',
					'hover_count_color'   => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group:hover .rtsb-count, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group:hover .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group:hover .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group:hover .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-filter-group:hover .rtsb-rating-star-wrapper + .rtsb-count',
					'active_color'        => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter.checked + label, {{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter.checked + label, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-term-item.selected .filter-attr-name, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-term-item.selected .filter-attr-name',
					'active_bg_color'     => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group.active, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group.active, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group.active, {{WRAPPER}} .rtsb-product-filters.rtsb-button.rtsb-filter-group.active',
					'active_count_color'  => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter.checked + label + .rtsb-count, {{WRAPPER}} .rtsb-product-filters input.rtsb-button-filter.checked + label + .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-term-item.selected .rtsb-color-filter .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-term-item.selected .rtsb-button-filter .rtsb-count, {{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter.checked + label + .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-ratings input.rtsb-checkbox-filter.checked + label .rtsb-rating-star-wrapper + .rtsb-count, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group.active .rtsb-count',
					'border'              => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group',
					'border_hover_color'  => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group:hover, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group:hover, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group:hover, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group:hover',
					'border_active_color' => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group.active, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group.active, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group.active, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group.active',
					'padding'             => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group',
					'margin'              => '{{WRAPPER}} .rtsb-product-filters .input-type-checkbox .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters .input-type-radio .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-filter-group, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group',
					'wrapper_padding'     => '{{WRAPPER}} .rtsb-product-filters .filter-content > ul',
					'wrapper_margin'      => '{{WRAPPER}} .rtsb-archive-filters-wrapper.horizontal-layout.has-floating .rtsb-product-filters > .filter-content > ul',
					'subcat_margin'       => '{{WRAPPER}} .rtsb-categories .filter-content ul ul',
				],
				'search_styles'  => [
					'typography'                => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field',
					'button_typography'         => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'icon_typography'           => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'placeholder_typography'    => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search ::-webkit-input-placeholder, {{WRAPPER}} .rtsb-archive-filters .rtsb-product-search ::placeholder',
					'search_input_height'       => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field',
					'search_button_width'       => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'search_button_height'      => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'search_icon_width'         => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit .search-icon, {{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit svg',
					'search_icon_height'        => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit .search-icon, {{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit svg',
					'color'                     => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field',
					'bg_color'                  => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field',
					'button_color'              => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'button_bg_color'           => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'placeholder_color'         => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search ::-webkit-input-placeholder, {{WRAPPER}} .rtsb-archive-filters .rtsb-product-search ::placeholder',
					'hover_color'               => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field:hover',
					'hover_bg_color'            => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field:hover',
					'hover_button_color'        => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit:hover',
					'hover_button_bg_color'     => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit:hover',
					'border'                    => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field',
					'button_border'             => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'border_hover_color'        => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field:hover',
					'active_border_color'       => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field:focus',
					'button_border_hover_color' => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit:hover',
					'input_border_radius'       => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field',
					'button_border_radius'      => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'search_clear_offset'       => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .search-input',
					'padding'                   => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field',
					'margin'                    => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-field',
					'button_padding'            => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'button_margin'             => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search .rtsb-search-submit',
					'title_padding'             => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-search.rtsb-product-search .filter-title-wrapper',
					'title_margin'              => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-search.rtsb-product-search .filter-title-wrapper',
					'wrapper_margin'            => '{{WRAPPER}} .rtsb-archive-filters .rtsb-product-search',
				],
				'checkbox'       => [
					'checkbox_size'             => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::before',
					'check_width'               => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::after',
					'check_height'              => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::after',
					'check_border'              => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::before',
					'checkmark_border'          => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::after',
					'check_h_alignment'         => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::after',
					'check_v_alignment'         => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::after',
					'border_color'              => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::before',
					'border_bg_color'           => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::before',
					'check_border_color'        => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::after',
					'check_bg_color'            => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::after',
					'outline_color'             => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::before',
					'border_hover_color'        => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-checkbox-filter + label::before',
					'border_hover_bg_color'     => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-checkbox-filter + label::before',
					'check_border_hover_color'  => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-checkbox-filter + label::after',
					'check_hover_bg_color'      => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-checkbox-filter + label::after',
					'border_active_color'       => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group.active input.rtsb-checkbox-filter + label::before',
					'border_active_bg_color'    => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group.active input.rtsb-checkbox-filter + label::before',
					'check_border_active_color' => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group.active input.rtsb-checkbox-filter + label::after',
					'check_active_bg_color'     => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group.active input.rtsb-checkbox-filter + label::after',
					'border_radius'             => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::before',
					'checkbox_margin'           => '{{WRAPPER}} .rtsb-product-filters input.rtsb-checkbox-filter + label::before',
				],
				'radio'          => [
					'radio_size'                   => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter + label::before',
					'dot_size'                     => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter.checked + label::after',
					'radio_border'                 => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter + label::before',
					'dot_h_alignment'              => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter.checked + label::after',
					'dot_v_alignment'              => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter.checked + label::after',
					'radio_border_color'           => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter + label::before',
					'radio_border_bg_color'        => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter + label::before',
					'dot_border_color'             => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter + label::after',
					'radio_border_hover_color'     => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-radio-filter + label::before',
					'radio_border_hover_bg_color'  => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-radio-filter + label::before',
					'dot_border_hover_color'       => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group:hover input.rtsb-radio-filter + label::after',
					'radio_border_active_color'    => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group.active input.rtsb-radio-filter + label::before',
					'radio_border_active_bg_color' => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group.active input.rtsb-radio-filter + label::before',
					'dot_border_active_color'      => '{{WRAPPER}} .rtsb-product-filters .rtsb-filter-group.active input.rtsb-radio-filter + label::after',
					'radio_margin'                 => '{{WRAPPER}} .rtsb-product-filters input.rtsb-radio-filter + label::before',
				],
				'other_inputs'   => [
					'color_input_count_display'        => '{{WRAPPER}} .rtsb-product-filters.rtsb-color .product-filters.no-label .rtsb-count',
					'color_input_outline'              => '{{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-color-filter .filter-attr-color',
					'button_input_count_display'       => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-count',
					'color_input_border'               => '{{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-color-filter .filter-attr-color',
					'button_input_color'               => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter .filter-attr-name, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter .rtsb-count',
					'button_input_bg_color'            => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter',
					'button_input_border'              => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter',
					'image_input_border'               => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-image-filter',
					'image_input_bg_color'             => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-image-filter',
					'color_input_hover_border_color'   => '{{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-term-item:hover .filter-attr-color',
					'button_input_hover_color'         => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter:hover, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter:hover .filter-attr-name, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter:hover .rtsb-count',
					'button_input_hover_bg_color'      => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter:hover',
					'button_input_hover_border_color'  => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter:hover',
					'image_input_hover_border_color'   => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-term-item:hover .rtsb-image-filter',
					'image_input_hover_bg_color'       => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-image-filter:hover',
					'color_input_active_border_color'  => '{{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-term-item.selected .filter-attr-color',
					'button_input_active_color'        => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-term-item.selected .rtsb-button-filter, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-term-item.selected .rtsb-button-filter .filter-attr-name, {{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-term-item.selected .rtsb-button-filter .rtsb-count',
					'button_input_active_bg_color'     => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-term-item.selected .rtsb-button-filter',
					'button_input_active_border_color' => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-term-item.selected .rtsb-button-filter',
					'image_input_active_border_color'  => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-term-item.selected .rtsb-image-filter',
					'image_input_active_bg_color'      => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-term-item.selected .rtsb-image-filter',
					'color_input_radius'               => '{{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-color-filter .filter-attr-color, {{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-color-filter .filter-attr-color::before',
					'button_input_radius'              => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter',
					'image_input_radius'               => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-image-filter',
					'color_input_padding'              => '{{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-color-filter .filter-attr-color',
					'button_input_padding'             => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-button-filter',
					'image_input_padding'              => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-image-filter',
					'color_input_margin'               => '{{WRAPPER}} .rtsb-product-filters.rtsb-color .rtsb-color-filter .filter-attr-color',
					'button_input_margin'              => '{{WRAPPER}} .rtsb-product-filters.rtsb-button .rtsb-filter-group',
					'image_input_margin'               => '{{WRAPPER}} .rtsb-product-filters.rtsb-image .rtsb-filter-group',
				],
				'price_slider'   => [
					'label_typography'               => '{{WRAPPER}} .rtsb-product-filters.rtsb-price .price-label .price-text',
					'text_typography'                => '{{WRAPPER}} .rtsb-product-filters.rtsb-price .price-label .price-result',
					'alignment'                      => '{{WRAPPER}} .rtsb-product-filters .filter-price',
					'handle_border'                  => '{{WRAPPER}} .rtsb-product-filters.rtsb-price .rtsb-price-slider .noUi-handle',
					'price_slider_label_color'       => [
						'color'    => '{{WRAPPER}} .rtsb-product-filters .filter-price',
						'bg_color' => '{{WRAPPER}} .rtsb-product-filters .price-filter-reset::before, {{WRAPPER}} .rtsb-product-filters .price-filter-reset:hover::before',
					],
					'price_slider_line_color'        => '{{WRAPPER}} .rtsb-product-filters.rtsb-price .rtsb-price-slider',
					'price_slider_active_line_color' => '{{WRAPPER}} .rtsb-product-filters.rtsb-price .rtsb-price-slider .noUi-connect',
					'price_slider_handle_color'      => '{{WRAPPER}} .rtsb-product-filters.rtsb-price .rtsb-price-slider .noUi-handle',
					'price_slider_handle_bg_color'   => '{{WRAPPER}} .rtsb-product-filters.rtsb-price .rtsb-price-slider .noUi-handle',
					'price_slider_label_margin'      => '{{WRAPPER}} .rtsb-product-filters .filter-price',
					'price_slider_wrapper_margin'    => '{{WRAPPER}} .rtsb-product-filters.rtsb-price .product-filters',
				],
				'rating'         => [
					'typography'            => '{{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-rating-star-wrapper .rtsb-rating-star',
					'count_display'         => '{{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-rating-star-wrapper + .rtsb-count',
					'count_position'        => '{{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-rating-star-wrapper + .rtsb-count',
					'rating_color'          => '{{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-rating-star-wrapper .rtsb-rating-star.inactive',
					'rating_active_color'   => '{{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-rating-star-wrapper .rtsb-rating-star.active',
					'rating_selected_color' => '{{WRAPPER}} .rtsb-product-filters.rtsb-ratings .rtsb-ajax-filter-trigger.checked + .rtsb-checkbox-filter-label .rtsb-rating-star.active',
					'rating_padding'        => '{{WRAPPER}} .rtsb-product-filters.rtsb-ratings .product-filters .rtsb-filter-group',
					'rating_margin'         => '{{WRAPPER}} .rtsb-product-filters.rtsb-ratings .product-filters .rtsb-filter-group',
				],
				'toggle_btn'     => [
					'typography'           => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle',
					'toggle_btn_alignment' => '{{WRAPPER}} .rtsb-archive-filters .rtsb-filter-toggle',
					'icon_display'         => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle .icon',
					'toggle_icon_size'     => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle .icon',
					'color'                => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle',
					'icon_color'           => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle .icon',
					'bg_color'             => [
						'bg_color'     => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle',
						'border_color' => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle::before',
					],
					'hover_color'          => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle:hover',
					'hover_icon_color'     => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle:hover .icon',
					'hover_bg_color'       => [
						'hover_bg_color'     => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle:hover',
						'hover_border_color' => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle:hover::before',
					],
					'border'               => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle',
					'border_hover_color'   => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle:hover',
					'border_radius'        => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle',
					'padding'              => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle',
					'margin'               => '{{WRAPPER}} .rtsb-archive-filters .product-filter-toggle',
				],
				'apply_btn'      => [
					'typography'         => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters',
					'apply_btn_width'    => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters',
					'icon_display'       => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters .icon',
					'apply_icon_size'    => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters .icon',
					'color'              => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters',
					'icon_color'         => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters .icon',
					'bg_color'           => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters',
					'hover_color'        => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters:hover',
					'hover_icon_color'   => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters:hover .icon',
					'hover_bg_color'     => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters:hover',
					'border'             => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters',
					'border_hover_color' => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters:hover',
					'border_radius'      => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters',
					'padding'            => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters',
					'margin'             => '{{WRAPPER}} .rtsb-archive-filters .rtsb-apply-filters-btn .rtsb-apply-filters',
				],
				'reset_btn'      => [
					'typography'         => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset',
					'alignment'          => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset',
					'btn_width'          => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset',
					'color'              => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset',
					'bg_color'           => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset',
					'hover_color'        => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset:hover',
					'hover_bg_color'     => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset:hover',
					'border'             => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset',
					'border_hover_color' => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset:hover',
					'border_radius'      => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset',
					'padding'            => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset',
					'margin'             => '{{WRAPPER}} .rtsb-product-filters.rtsb-reset .product-filter-reset',
				],
				'active_filters' => [
					'color'              => '.rtsb-active-filters-wrapper .rtsb-active-filters, .rtsb-active-filters-wrapper .rtsb-active-filters .active-filter .filter-name, .rtsb-active-filters-wrapper .rtsb-active-filters .rtsb-clear-filters',
					'bg_color'           => '.rtsb-active-filters-wrapper .rtsb-active-filters .active-filter .filter-item',
					'icon_color'         => '.rtsb-active-filters-wrapper .rtsb-active-filters .active-filter .remove-filter > i',
					'icon_bg_color'      => '.rtsb-active-filters-wrapper .rtsb-active-filters .active-filter .remove-filter > i',
					'border_color'       => '.rtsb-active-filters-wrapper .rtsb-active-filters .active-filter .filter-item',
					'hover_color'        => '.rtsb-active-filters-wrapper .rtsb-active-filters .active-filter .filter-item:hover, .rtsb-active-filters-wrapper .rtsb-active-filters .rtsb-clear-filters:hover',
					'hover_bg_color'     => '.rtsb-active-filters-wrapper .rtsb-active-filters .active-filter .filter-item:hover',
					'border_hover_color' => '.rtsb-active-filters-wrapper .rtsb-active-filters .active-filter .filter-item:hover',
					'wrapper_bg_color'   => '.rtsb-active-filters-wrapper .rtsb-active-filters',
					'border_radius'      => '.rtsb-active-filters-wrapper .rtsb-active-filters',
					'padding'            => '.rtsb-active-filters-wrapper .rtsb-active-filters',
					'margin'             => '.rtsb-active-filters-wrapper .rtsb-active-filters',
				],
				'filter_group'   => [
					'btn_v_alignment'        => '{{WRAPPER}} .rtsb-archive-filters-wrapper .filter-btn-wrapper',
					'border'                 => '{{WRAPPER}} .rtsb-archive-filters-wrapper .rtsb-product-filters',
					'wrapper_border'         => '{{WRAPPER}} .rtsb-archive-filters',
					'wrapper_border_radius'  => '{{WRAPPER}} .rtsb-archive-filters',
					'padding'                => '{{WRAPPER}} .rtsb-archive-filters-wrapper .rtsb-product-filters',
					'margin'                 => '{{WRAPPER}} .rtsb-archive-filters-wrapper .rtsb-product-filters',
					'active_wrapper_padding' => '{{WRAPPER}} .rtsb-product-filters.active',
					'wrapper_padding'        => '{{WRAPPER}} .rtsb-archive-filters',
					'wrapper_margin'         => '{{WRAPPER}} .rtsb-archive-filters',
				],
			],
		];
	}

	/**
	 * Social Share Style Controls.
	 *
	 * @param array $selectors Selectors.
	 *
	 * @return array
	 */
	public static function pro_social_selectors( $selectors ) {
		$pro_selectors = [
			'share_toggle_styles' => [
				'icon_size'          => [
					'font_size' => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle .toggle-icon',
					'width'     => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle .toggle-icon svg',
				],
				'width'              => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle .toggle-icon',
				'height'             => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle .toggle-icon',
				'item_spacing'       => [
					'vertical'   => '{{WRAPPER}} .rtsb-social-share-container.has-toggle.vertical .rtsb-social-share',
					'horizontal' => 'html:not([dir=rtl]) {{WRAPPER}} .rtsb-social-share-container.has-toggle.horizontal .rtsb-social-share',
					'rtl'        => 'html[dir=rtl] {{WRAPPER}} .rtsb-social-share-container.has-toggle.horizontal .rtsb-social-share',
				],
				'color'              => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle',
				'bg_color'           => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle',
				'hover_color'        => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle:hover, {{WRAPPER}} .rtsb-social-share-container.active .rtsb-share-toggle',
				'hover_bg_color'     => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle:hover, {{WRAPPER}} .rtsb-social-share-container.active .rtsb-share-toggle',
				'border'             => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle',
				'border_hover_color' => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle:hover, {{WRAPPER}} .rtsb-social-share-container.active .rtsb-share-toggle',
				'border_radius'      => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle',
				'padding'            => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle',
				'margin'             => '{{WRAPPER}} .rtsb-social-share-container .rtsb-share-toggle',
			],
		];

		return array_merge( $selectors, $pro_selectors );
	}

	/**
	 * Social Share Style Controls.
	 *
	 * @param array $selectors Selectors.
	 *
	 * @return array
	 */
	public static function product_loop_default_selectors( $selectors ) {
		$selectors['show_qc_btn_selector'] = [
			'typography'         => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn',
			'alignment'          => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn',
			'color'              => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn',
			'bg_color'           => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn',
			'hover_color'        => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn:hover',
			'hover_bg_color'     => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn:hover',
			'border'             => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn',
			'border_hover_color' => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn:hover',
			'padding'            => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn',
			'margin'             => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn',
			'qc_btn_height'      => '{{WRAPPER}} .rtsb-checkout-and-add-to-cart .rtsb-quick-checkout-btn',
		];

		return $selectors;
	}

	/**
	 * Advanced Product Tab Style Controls.
	 *
	 * @return array
	 */
	public static function advanced_product_tabs_selectors() {
		$selectors =
			[
				'rtsb-advance-product-tabs' => array_merge(
					ControlSelectors::reviews_settings_selecotor(),
					[
						'nav_typography'                  => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li a',
						'nav_position'                    => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 ul.wc-tabs',
						'nav_color'                       => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li a',
						'nav_bg_color'                    => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li a',
						'nav_border'                      => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li,#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 ul.wc-tabs li a',

						'nav_active_color'                => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li.active a',
						'nav_active_bg_color'             => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li.active a',
						'nav_active_border_color'         => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li.active,#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 ul.wc-tabs li.active a',
						'nav_hover_color'                 => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li:not(.active):hover a',
						'nav_hover_bg_color'              => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li:not(.active):hover a',
						'nav_active_hover_color'          => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li.active:hover a',
						'nav_active_hover_bg_color'       => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li.active:hover a',
						'nav_active_hover_border_color'   => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs ul.tabs li.active:hover a',
						'nav_padding'                     => '#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs  .woocommerce-tabs ul.tabs li a ',
						'content_padding'                 => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs  .woocommerce-tabs .wc-tab,#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content',

						'show_title'                      => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs .woocommerce-Tabs-panel > h2:first-child,{{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs .woocommerce-Tabs-panel .comment-reply-title, {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs .woocommerce-Tabs-panel  .woocommerce-Reviews-title,#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content > h2',
						'tab_title_typography'            => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs .wc-tab h2,#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content > h2, #rtsb-builder-content {{WRAPPER}} .rtsb-product-advanced-tabs .custom-title',
						'tab_title_gap'                   => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs .wc-tab h2,#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content > h2, #rtsb-builder-content {{WRAPPER}} .rtsb-product-advanced-tabs .custom-title',
						'tab_content_title_color'         => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs .woocommerce-Tabs-panel > h2:first-child, {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs .woocommerce-Tabs-panel .woocommerce-Reviews-title,#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content > h2, #rtsb-builder-content {{WRAPPER}} .rtsb-product-advanced-tabs .custom-title',

						'additional_info_typography'      => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs .woocommerce-tabs .wc-tab .shop_attributes,#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content .shop_attributes',
						'attributes_gap'                  => '.rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs table.shop_attributes td,{{WRAPPER}} .rtsb-product-tabs table.shop_attributes th',
						'accordion_title_typography'      => '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title',
						'accordion_title_color'           => '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title',
						'accordion_title_icon_color'      => '#rtsb-builder-content {{WRAPPER}} .rtsb-tab-accordion-item .rtsb-accordion-title.active:after',
						'accordion_title_icon_active_color' => '#rtsb-builder-content {{WRAPPER}} .rtsb-tab-accordion-item .rtsb-accordion-title:after',
						'accordion_title_bg_color'        => '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title',
						'accordion_title_active_color'    => '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title.active',
						'accordion_title_padding'         => '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title',
						'accordion_title_active_bg_color' => '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title.active',
						'accordion_title_border_radius'   => '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title',
						'accordion_border_radius'         => '#rtsb-builder-content {{WRAPPER}} .rtsb-tab-accordion-item,#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 .wc-tabs-wrapper',
						'nav_border_radius'               => '#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 ul.wc-tabs li a',

					]
				),
			];

		return apply_filters( 'rtsb/elements/elementor/widget/advanced_product_tabs/selectors', $selectors );
	}

	/**
	 * Product Stock Count Style Controls.
	 *
	 * @return array
	 */
	public static function product_stock_count_selectors() {
		$selectors =
			[
				'rtsb-product-stock-count' => self::product_stock_count_common_selectors(),

			];

		return apply_filters( 'rtsb/elements/elementor/widget/product_stock_count/selectors', $selectors );
	}

	/**
	 * Highlighted Product Style Controls.
	 *
	 * @return array
	 */
	public static function highlighted_product_selectors() {
		$selectors =
			[
				'rtsb-highlighted-product' => [
					'product_image_width'               => '{{WRAPPER}} .rtsb-highlighted-product .rtwpvg-images,{{WRAPPER}} .rtsb-highlighted-product .product-item .images',
					'product_image_gap'                 => '{{WRAPPER}} .rtsb-highlighted-product-wrapper .product-item',
					'vertical_alignment'                => '{{WRAPPER}} .rtsb-highlighted-product-wrapper .rtsb-highlighted-product .rtsb-highlighted-product-content',
					'gallery_thumbs_column'             => '{{WRAPPER}} div.images .flex-control-thumbs li',
					'thumb_border'                      => '{{WRAPPER}} .rtsb-highlighted-product div.images .flex-control-thumbs li img, {{WRAPPER}} .rtsb-highlighted-product .rtwpvg-thumbnail-image img',
					'thumbs_border_radius'              => '{{WRAPPER}} .rtsb-highlighted-product div.images .flex-control-thumbs li img, {{WRAPPER}} .rtsb-highlighted-product .rtwpvg-thumbnail-image img',
					'image_wrapper_margin'              => '{{WRAPPER}} .rtsb-highlighted-product .rtwpvg-images,{{WRAPPER}} .rtsb-highlighted-product div.images',
					'module_width'                      => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn) .icon',
					'module_height'                     => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn) .icon',
					'module_item_gap'                   => '{{WRAPPER}} :is( .action-button-wrapper, .rtsb-actions-button )',
					'module_item_alignment'             => '{{WRAPPER}} :is( .action-button-wrapper, .rtsb-actions-button )',
					'module_text_color_normal'          => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn)',
					'module_bg_color_normal'            => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn) .icon',
					'module_border'                     => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn) .icon',
					'module_text_color_hover'           => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn):hover',
					'module_bg_color_hover'             => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn):hover .icon',
					'module_border_hover_color'         => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn):hover .icon',
					'module_border_radius'              => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn) .icon',
					'icon_size'                         => [
						'icon' => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn) .icon',
						'svg'  => '{{WRAPPER}} a:is(.rtsb-wishlist-btn,.rtsb-compare-btn,.rtsb-quick-view-btn) .icon svg',
					],
					'module_wrapper_margin'             => '{{WRAPPER}} :is( .action-button-wrapper, .rtsb-actions-button )',
					'module_text_typo'                  => '{{WRAPPER}} .rtsb-actions-button .button-text',
					'module_text_color'                 => '{{WRAPPER}} .rtsb-actions-button .button-text',
					'module_text_hover_color'           => '{{WRAPPER}} .rtsb-actions-button .button-text:hover',
					'module_text_margin'                => '{{WRAPPER}} .rtsb-actions-button .button-text',
					'label_typo'                        => '.rtsb-highlighted-product .sku-label',
					'meta_label_color'                  => '.rtsb-highlighted-product .sku-label',
					'value_typo'                        => '.rtsb-highlighted-product .rtsb-product-categories a,.rtsb-highlighted-product .rtsb-product-sku .sku-value',
					'meta_value_color'                  => '.rtsb-highlighted-product  .rtsb-product-categories a,.rtsb-highlighted-product .rtsb-product-sku .sku-value',
					'meta_value_hover_color'            => '.rtsb-highlighted-product .rtsb-product-categories a:hover',
					'meta_margin'                       => '.rtsb-highlighted-product .product-meta',
					'sku_margin'                        => '.rtsb-highlighted-product .rtsb-product-sku',
					'rating_text_link_color'            => '{{WRAPPER}} .product-rating .rtsb-count',
					'link_typography'                   => '{{WRAPPER}} .product-rating .rtsb-count',
					'rating_space_between'              => [
						'margin-right' => 'body:not(.rtl) {{WRAPPER}} .star-rating',
						'margin-left'  => 'body.rtl {{WRAPPER}} .star-rating',
					],
					'review_star_icon_default_color'    => '{{WRAPPER}} .star-rating::before, {{WRAPPER}} p.stars a:before, {{WRAPPER}} p.stars a:hover~a:before, {{WRAPPER}} p.stars.selected a.active~a:before',
					'review_star_icon_color'            => '{{WRAPPER}} .star-rating span::before, {{WRAPPER}} p.stars.selected a.active:before, {{WRAPPER}} p.stars:hover a:before, {{WRAPPER}} p.stars.selected a:not(.active):before, {{WRAPPER}} p.stars.selected a.active:before',
					'review_star_icon_size'             => '{{WRAPPER}} .star-rating',
					'review_star_icon_specing'          => '{{WRAPPER}} .star-rating',
					'title_typo'                        => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-highlighted-product-content .product_title',
					'title_align'                       => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-highlighted-product-content .product_title',
					'title_color'                       => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-highlighted-product-content .product_title',
					'title_text_stroke'                 => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-highlighted-product-content .product_title',
					'title_text_shadow'                 => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-highlighted-product-content .product_title',
					'title_border'                      => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-highlighted-product-content .product_title',
					'title_margin'                      => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-highlighted-product-content .product_title',
					'title_padding'                     => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-highlighted-product-content .product_title',
					'price_typo'                        => '{{WRAPPER}} .rtsb-product-price :is(.price, .price .amount, .price ins)',
					'price_align'                       => '{{WRAPPER}} .rtsb-highlighted-product .rtsb-product-price',
					'price_color'                       => '{{WRAPPER}} .rtsb-product-price :is(.price, .price .amount, .price ins)',
					'sale_price_typo'                   => '{{WRAPPER}} .rtsb-product-price .price ins .amount',
					'sale_price_color'                  => '{{WRAPPER}} .rtsb-product-price .price ins .amount',
					'price_margin'                      => '{{WRAPPER}} .rtsb-product-price',
					'typo'                              => '{{WRAPPER}} .rtsb-highlighted-product-content .short-description',
					'align'                             => '{{WRAPPER}} .rtsb-highlighted-product-content .short-description',
					'text_color'                        => '{{WRAPPER}} .rtsb-highlighted-product-content .short-description',
					'text_shadow'                       => '{{WRAPPER}} .rtsb-highlighted-product-content .short-description',
					'stock_text_align'                  => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
					'product_stock_text_typography'     => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
					'product_stock_count_typography'    => '{{WRAPPER}} .rtsb-product-stock .stock-sold span',
					'product_stock_text_color'          => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
					'product_stock_count_color'         => '{{WRAPPER}} .rtsb-product-stock .stock-sold span',
					'product_stock_count_bgcolor'       => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
					'stock_text_border'                 => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
					'product_stock_text_padding'        => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
					'product_stock_text_margin'         => '{{WRAPPER}} .rtsb-product-stock .stock-sold',
					'product_stock_progress_bg_color'   => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress',
					'product_stock_progress_stock_bg_color' => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress .rtsb-product-stock-progress-bar',
					'product_stock_progress_height'     => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress .rtsb-product-stock-progress-bar',
					'product_stock_border_radius'       => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress .rtsb-product-stock-progress-bar,{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress',
					'product_stock_margin'              => '{{WRAPPER}} .rtsb-product-stock .rtsb-product-stock-progress',
					'stock_wrapper_bg'                  => '{{WRAPPER}} .rtsb-product-stock',
					'stock_wrapper_border'              => '{{WRAPPER}} .rtsb-product-stock',
					'stock_wrapper_shadow'              => '{{WRAPPER}} .rtsb-product-stock',
					'stock_wrapper_border_radius'       => '{{WRAPPER}} .rtsb-product-stock',
					'stock_wrapper_padding'             => '{{WRAPPER}} .rtsb-product-stock',
					'stock_wrapper_margin'              => '{{WRAPPER}} .rtsb-product-stock',
					'variation_label_typography'        => '{{WRAPPER}} .rtsb-highlighted-product  table.variations tr .label label',
					'variation_stock_typography'        => '{{WRAPPER}} .rtsb-highlighted-product  .woocommerce-variation-availability .stock',
					'variation_label_color'             => '{{WRAPPER}} .rtsb-highlighted-product  table.variations tr .label label',
					'variation_stock_color'             => '{{WRAPPER}} .rtsb-highlighted-product  .woocommerce-variation-availability .stock',
					'variation_outofstock_color'        => '{{WRAPPER}} .rtsb-highlighted-product  .woocommerce-variation-availability .stock.out-of-stock',
					'variation_height'                  => '.rtwpvs  {{WRAPPER}} .rtwpvs-terms-wrapper .rtwpvs-term:not(.rtwpvs-radio-term).rtwpvs-button-term, {{WRAPPER}} .rtsb-highlighted-product .variations select',
					'variation_width'                   => '.rtwpvs  {{WRAPPER}} .rtwpvs-terms-wrapper .rtwpvs-term:not(.rtwpvs-radio-term).rtwpvs-button-term, {{WRAPPER}} .rtsb-highlighted-product .variations select',
					'variation_border'                  => '.rtwpvs  {{WRAPPER}} .rtwpvs-terms-wrapper .rtwpvs-term:not(.rtwpvs-radio-term).rtwpvs-button-term, {{WRAPPER}} .rtsb-highlighted-product .variations select',
					'variation_border_radius'           => '.rtwpvs  {{WRAPPER}} .rtwpvs-terms-wrapper .rtwpvs-term:not(.rtwpvs-radio-term).rtwpvs-button-term, {{WRAPPER}} .rtsb-highlighted-product .variations select',
					'variation_padding'                 => '{{WRAPPER}} .rtsb-highlighted-product .variations select',
					'variation_label_margin'            => '{{WRAPPER}} .rtsb-highlighted-product  table.variations tr .label',
					'variation_item_margin'             => '{{WRAPPER}} .rtsb-highlighted-product table.variations tr:not(:last-child) .value',
					'button_typography'                 => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'button_height'                     => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'button_width'                      => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'button_text_color_normal'          => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'button_bg_color_normal'            => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'button_border'                     => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'button_text_color_hover'           => '{{WRAPPER}} .rtsb-highlighted-product .cart .button:hover',
					'button_bg_color_hover'             => '{{WRAPPER}} .rtsb-highlighted-product .cart .button:hover',
					'button_border_hover_color'         => '{{WRAPPER}} .rtsb-highlighted-product .cart .button:hover',
					'button_border_radius'              => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'button_padding'                    => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'button_margin'                     => '{{WRAPPER}} .rtsb-highlighted-product .cart .button',
					'variation_price_typography'        => '{{WRAPPER}}  .single_variation :is(.price, .price .amount, .price ins)',
					'variation_price_color'             => '{{WRAPPER}}  .single_variation :is(.price, .price .amount, .price ins)',
					'variation_price_margin'            => '{{WRAPPER}}  .rtsb-highlighted-product .single_variation',
					'quantity_height'                   => [
						'full' => '{{WRAPPER}} .rtsb-product-add-to-cart input[type=number], {{WRAPPER}} .rtsb-quantity-box-group:is(.rtsb-quantity-box-group-style-1,.rtsb-quantity-box-group-style-2) .rtsb-quantity-btn',
						'half' => '{{WRAPPER}} .rtsb-quantity-box-group:is(.rtsb-quantity-box-group-style-3,.rtsb-quantity-box-group-style-4) .rtsb-quantity-btn',
					],
					'quantity_increment_button_padding' => '{{WRAPPER}} .rtsb-product-add-to-cart .rtsb-quantity-box-group .rtsb-quantity-btn.rtsb-quantity-plus',
					'quantity_decrement_button_padding' => '{{WRAPPER}} .rtsb-product-add-to-cart .rtsb-quantity-box-group .rtsb-quantity-btn.rtsb-quantity-minus',
					'quantity_input_width'              => '{{WRAPPER}} .rtsb-product-add-to-cart input.qty',
					'quantity_button_width'             => '{{WRAPPER}} .rtsb-product-add-to-cart .rtsb-quantity-box-group .rtsb-quantity-btn',
					'quantity_icon_size'                => '{{WRAPPER}} .rtsb-product-add-to-cart .rtsb-quantity-box-group .rtsb-quantity-btn',
					'quantity_icon_color'               => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity i',
					'quantity_icon_hover_color'         => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity .rtsb-quantity-btn:hover i',
					'text_typography'                   => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity input',
					'quantity_number_color'             => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity input',
					'quantity_background_color'         => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity input',
					'quantity_border'                   => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity input',
					'quantity_radius'                   => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity input',
					'qunatity_padding'                  => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity input',
					'quantity_wrapper_background_color' => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity .rtsb-quantity-box-group',
					'qunatity_wrapper_padding'          => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity .rtsb-quantity-box-group',
					'quantity_wrapper_radius'           => '{{WRAPPER}} .rtsb-product-add-to-cart .quantity .rtsb-quantity-box-group',
				],

			];

		return apply_filters( 'rtsb/elements/elementor/widget/highlighted_product/selectors', $selectors );
	}
	/**
	 * Product QR Code Style Controls.
	 *
	 * @return array
	 */
	public static function product_qr_code_selectors() {
		$selectors = [
			'rtsb-product-product-qr-code' => [
				'title_text_typography' => '{{WRAPPER}} .rtsb-product-qr-code-wrapper .qr-title',
				'title_color'           => '{{WRAPPER}} .rtsb-product-qr-code-wrapper .qr-title',
				'title_text_margin'     => '{{WRAPPER}} .rtsb-product-qr-code-wrapper .qr-title',
				'qr_code_color'         => '{{WRAPPER}} .rtsb-product-qr-code-wrapper .qr-title',
				'qr_code_bgcolor'       => '{{WRAPPER}} .rtsb-product-qr-code-wrapper .qr-title',
			],
		];
		return apply_filters( 'rtsb/elements/elementor/widget/qr_code/selectors', $selectors );
	}

	/**
	 * Multi Step Checkout Style Controls.
	 *
	 * @return array
	 */
	public static function multi_step_checkout_selectors() {
		$selectors = [
			'rtsb-multi-step-checkout' => [
				'show_title'                     => '{{WRAPPER}} .woocommerce-billing-fields h3,{{WRAPPER}} .rtrb-checkout-step-billing h3:not(#ship-to-different-address),{{WRAPPER}} .rtrb-checkout-step-order h3:not(#ship-to-different-address),{{WRAPPER}} .rtrb-checkout-step-shipping h3:not(#ship-to-different-address),{{WRAPPER}} .rtrb-checkout-step-payment h3:not(#ship-to-different-address)',
				'step_title_typography'          => '{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item .rtrb-checkout-tab-text',
				'step_icon_size'                 => [
					'icon' => '{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item .icon',
					'svg'  => '{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item .icon svg',
				],
				'step_disable_title_color'       => '{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item .rtrb-checkout-tab-text,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item .icon',
				'step_disable_fill_color'        => '{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item.current ~ li::after,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item.current + li ~ li::before,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item:nth-child(1)::before,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item.current ~ li .rtrb-checkout-tab-number span::after,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item.current ~ li .rtrb-checkout-tab-number',
				'step_active_title_color'        => '{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item.current .rtrb-checkout-tab-text,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item.current .icon',
				'step_item_active_border'        => '{{WRAPPER}} .rtrb-checkout-multistep-wrapper.layout2 .rtrb-checkout-tab-item.current,{{WRAPPER}} .rtrb-checkout-multistep-wrapper.layout2 .rtrb-checkout-steps-wrapper',
				'step_active_fill_color'         => '{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item::after,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item.current:not(:last-child)::after,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item.current + li::before,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item::before,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item .rtrb-checkout-tab-number span::after,{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item .rtrb-checkout-tab-number',
				'step_margin'                    => '{{WRAPPER}} .rtrb-checkout-tab-container',
				'step_title_position'            => '{{WRAPPER}} .rtrb-checkout-tab-container .rtrb-checkout-tab-item .rtrb-checkout-tab-text',
				'infobox_typography'             => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon .woocommerce-form-coupon p,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon .woocommerce-info,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon .woocommerce-info a',
				'infobox_bg_color'               => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon',
				'infobox_text_color'             => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon .woocommerce-form-coupon p',
				'infobox_text_link_color'        => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon .woocommerce-info a',
				'infobox_border_color'           => '',
				'infobox_icon_size'              => [
					'icon' => '',
					'svg'  => '',
				],
				'infobox_icon_color'             => '',
				'infobox_icon_margin'            => '{{WRAPPER}} .woocommerce-info::before, {{WRAPPER}} .woocommerce-info :is( i, svg ), {{WRAPPER}} .wc-block-components-notice-banner :is( i, svg )',
				'infobox_wrapper_border'         => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon',
				'infobox_border_radius'          => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon',
				'infobox_padding'                => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce_checkout_coupon',
				'title_typo'                     => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-billing-fields >h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-order > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-payment > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-shipping > h3',
				'title_align'                    => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-billing-fields >h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-order > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-payment > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-shipping > h3',
				'title_color'                    => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-billing-fields >h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-order > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-payment > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-shipping > h3',
				'title_text_stroke'              => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-billing-fields >h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-order > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-payment > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-shipping > h3',
				'title_text_shadow'              => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-billing-fields >h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-order > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-payment > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-shipping > h3',
				'title_border'                   => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-billing-fields >h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-order > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-payment > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-shipping > h3',
				'title_margin'                   => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-billing-fields >h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-order > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-payment > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-shipping > h3',
				'title_padding'                  => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-billing-fields >h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-order > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-payment > h3,{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-step-shipping > h3',
				'fields_label_typo'              => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout label',
				'fields_label_color'             => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout label',
				'fields_label_reguired_color'    => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout label abbr',
				'fields_label_margin'            => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout label',
				'fields_height'                  => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout input,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout select,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout textarea,{{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-selection--single',
				'fields_border'                  => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout input,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout select,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout textarea,{{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-selection--single',
				'fields_border_radius'           => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout input,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout select,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout textarea,{{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-selection--single',
				'fields_text_color'              => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout input,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout select,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout textarea,{{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-selection--single',
				'fields_bg_color'                => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout input,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout select,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout textarea,{{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-selection--single',
				'fields_hover_border'            => '{{WRAPPER}} .rtrb-checkout-steps-wrapper input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-container--open .select2-selection--single, {{WRAPPER}} .rtrb-checkout-steps-wrapper select:is(:hover, :focus, :active,:focus-visible)',
				'fields_border_radius_hover'     => '{{WRAPPER}} .rtrb-checkout-steps-wrapper input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-container--open .select2-selection--single, {{WRAPPER}} .rtrb-checkout-steps-wrapper select:is(:hover, :focus, :active,:focus-visible)',
				'fields_hover_text_color'        => '{{WRAPPER}} .rtrb-checkout-steps-wrapper input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-container--open .select2-selection--single, {{WRAPPER}} .rtrb-checkout-steps-wrapper select:is(:hover, :focus, :active,:focus-visible)',
				'fields_hover_bg_color'          => '{{WRAPPER}} .rtrb-checkout-steps-wrapper input:not([type=checkbox],[type=radio]):is(:hover, :focus, :active), {{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-container--open .select2-selection--single, {{WRAPPER}} .rtrb-checkout-steps-wrapper select:is(:hover, :focus, :active,:focus-visible)',
				'fields_padding'                 => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout input,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout select,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout textarea,{{WRAPPER}} .rtrb-checkout-steps-wrapper .select2-selection--single',
				'form_row_margin'                => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout .form-row',
				'payment_label_typo'             => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .wc_payment_methods .wc_payment_method label',
				'payment_text_typo'              => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .wc_payment_methods .wc_payment_method p,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-privacy-policy-text p',
				'payment_box_border'             => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .wc_payment_methods .wc_payment_method,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout-payment .place-order',
				'payment_box_border_radius'      => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .wc_payment_methods .wc_payment_method,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout-payment .place-order',
				'payment_label_color'            => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .wc_payment_methods .wc_payment_method label',
				'payment_text_color'             => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .wc_payment_methods .wc_payment_method p,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-privacy-policy-text p',
				'payment_bg_color'               => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .wc_payment_methods .wc_payment_method,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout-payment .place-order',
				'payment_box_padding'            => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .wc_payment_methods .wc_payment_method,{{WRAPPER}} .rtrb-checkout-steps-wrapper .woocommerce-checkout-payment .place-order',
				'button_typography'              => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev',
				'button_height'                  => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev',
				'button_width'                   => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button',
				'button_text_color_normal'       => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev',
				'button_bg_color_normal'         => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev',
				'button_border'                  => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev',
				'button_text_color_hover'        => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button:is(:hover,:focus,:active),{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart:hover,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next:hover,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev:hover,{{WRAPPER}} .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart:hover',
				'button_bg_color_hover'          => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button:is(:hover,:focus,:active),{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next:hover,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev:hover,{{WRAPPER}} .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart:hover',
				'button_border_hover_color'      => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button:is(:hover,:focus,:active),{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next:hover,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev:hover,{{WRAPPER}} .rtrb-checkout-nav-wrapper #rtrb-checkout-back-to-cart:hover',
				'button_border_radius'           => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-next,{{WRAPPER}} .rtrb-checkout-multistep-wrapper .rtrb-checkout-nav-wrapper #rtrb-checkout-prev',
				'button_padding'                 => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button',
				'button_margin'                  => '{{WRAPPER}} .rtrb-checkout-steps-wrapper .rtrb-checkout-nav-wrapper .button',
				'table_heading_cell_border'      => '{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table,{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table td,{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table tfoot th',
				'table_heading_cell_padding'     => '{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table th,{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table td',
				'total_heading_width'            => '',
				'total_cell_heading_width'       => '',
				'table_product_title'            => '',
				'table_heading_typography'       => '{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table tfoot th,{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table thead th',
				'table_heading_color'            => '{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table tfoot th,{{WRAPPER}} .rtrb-checkout-steps-wrapper form #order_review .woocommerce-checkout-review-order-table thead th',
				'table_heading_background_color' => '',
				'table_heading_align'            => '',
				'table_cell_typography'          => '',
				'table_cell_color'               => '',
				'table_cell_background_color'    => '',
				'table_cell_align'               => '',

			],
		];

		return apply_filters( 'rtsb/elements/elementor/widget/multi_step_checkout/selectors', $selectors );
	}
}
