<?php
/**
 * Elementor AddonHelpersPro Class.
 *
 * This class contains helpers for general addons.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Helpers;

use RadiusTheme\SB\Helpers\Fns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Elementor GeneralAddons Class.
 */
class AddonHelpersPro {
	/**
	 * Render General Image.
	 *
	 * @param array $args Arguments.
	 *
	 * @return void
	 */
	public static function render_general_image( $args = [] ) {
		$args = array_merge(
			[
				'image'             => '',
				'size'              => 'thumbnail',
				'custom_image_args' => [],
			],
			$args
		);

		if ( empty( $args['image'] ) ) {
			return;
		}

		$image             = $args['image'];
		$size              = $args['size'];
		$custom_image_args = $args['custom_image_args'];
		$custom_image_size = ! empty( $custom_image_args['custom'] ) && is_array( $custom_image_args['custom'] )
			? array_merge( $custom_image_args['custom'], [ 'crop' => $custom_image_args['crop'] ?? 'hard' ] )
			: [];

		$image_id = ! empty( $image['id'] ) ? $image['id'] : $image;
		$img_html = Fns::get_product_image_html( '', null, $size, $image_id, $custom_image_size );

		Fns::print_html( $img_html );
	}
	/**
	 * General Widgets Logo Slider And Grid Layouts
	 *
	 * @return array
	 */
	public static function general_widgets_hero_slider() {

		return apply_filters(
			'rtsb/elements/elementor/general_widgets_hero_slider_layouts',
			[
				'rtsb-hero-slider-layout1' => [
					'title' => esc_html__( 'Layout 1', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/hero-slider-layout-1.png' ) ),
				],
				'rtsb-hero-slider-layout2' => [
					'title' => esc_html__( 'Layout 2', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/hero-slider-layout-2.png' ) ),
				],
				'rtsb-hero-slider-layout3' => [
					'title' => esc_html__( 'Layout 3', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/hero-slider-layout-3.png' ) ),
				],
				'rtsb-hero-slider-layout4' => [
					'title' => esc_html__( 'Layout 4', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/hero-slider-layout-4.png' ) ),
				],
			]
		);
	}
}
