<?php
/**
 * Pro Example Shortcode Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Controllers\Frontend\Shortcodes;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;
use WC_Product;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Add to Cart Ajax Class.
 */
class ProductStockCount {
	/**
	 * Singleton.
	 */
	use SingletonTrait;

	/**
	 * Class Constructor.
	 *
	 * @return void
	 */
	private function __construct() {
		add_shortcode( 'product_stock_count', [ $this, 'shortcode' ] );
	}

	/**
	 * Method to render the shortcodes.
	 *
	 * @param array $atts Shortcode attributes.
	 *
	 * @return string
	 * @since  1.0.0
	 */
	public function shortcode( $atts, $content = '' ) {
		if ( ! apply_filters( 'rtsb/product_stock_count/show_count', true ) ) {
			return;
		}
		$atts = shortcode_atts(
			[
				'show_stock_text'     => 'yes',
				'show_stock_progress' => 'yes',
				'wrapper_class'       => '',
				'layout'              => 'layout1',
				'stock_text'          => __( 'Only %d item(s) left in stock.', 'shopbuilder-pro' ),
			],
			$atts
		);
		global $product;
		if ( ! $product instanceof WC_Product ) {
			return '';
		}
		ob_start();

		$data = [
			'template' => 'shortcode/product-stock-count/' . $atts['layout'],
			'settings' => $atts,
		];

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		return ob_get_clean();
	}


}
