<?php
/**
 * Pro Example Shortcode Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Controllers\Frontend\Shortcodes;

use RadiusTheme\SB\Helpers\BuilderFns;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Modules\GiftCard\GiftCardFns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;
use WC_Product;
use WP_Query;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Add to Cart Ajax Class.
 */
class GiftCardDisplay {
	/**
	 * Singleton.
	 */
	use SingletonTrait;

	/**
	 * Class Constructor.
	 *
	 * @return void
	 */
	private function __construct() {
		add_shortcode( 'gift_card_list', [ $this, 'shortcode_gift_card_list' ] );
		add_shortcode( 'gift_card_info', [ $this, 'shortcode_gift_card_info' ] );
		add_shortcode( 'gift_card_activity', [ $this, 'shortcode_gift_card_activity' ] );
	}

	/**
	 * @param $atts
	 * @return void
	 */
	private function get_first_card_id() {
		$args  = [
			'post_type'      => GiftCardFns::GIFT_CARD_POST_TYPE,
			'post_status'    => 'publish',
			'meta_key'       => 'purchase_by',
			'meta_value'     => get_current_user_id(),
			'orderby'        => 'ID',
			'order'          => 'ASC',
			'posts_per_page' => 1,
		];
		$query = new WP_Query( $args );
		if ( $query->have_posts() ) {
			$card = $query->posts[0]; // Get the first (latest) post.
			return $card->ID;
		}
		return null;
	}
	/**
	 * Method to render the shortcodes.
	 *
	 * @param array $atts Shortcode attributes.
	 *
	 * @return string
	 * @since  1.0.0
	 */
	public function shortcode_gift_card_list( $atts, $content = '' ) {
		if ( ! Fns::is_module_active( 'gift_card' ) ) {
			ob_start();
			FnsPro::custom_notice( esc_html__( 'Please activate Gift Card module to use &#91;gift_card_list&#93; shortcode.', 'shopbuilder-pro' ) );
			return ob_get_clean();
		}
		do_action( 'woocommerce_account_rtsb-gift-cards_endpoint' );
	}
	/**
	 * Method to render the shortcodes.
	 *
	 * @param array $atts Shortcode attributes.
	 *
	 * @return string
	 * @since  1.0.0
	 */
	public function shortcode_gift_card_info( $atts, $content = '' ) {
		if ( ! Fns::is_module_active( 'gift_card' ) ) {
			ob_start();
			FnsPro::custom_notice( esc_html__( 'Please activate Gift Card module to use &#91;gift_card_list&#93; shortcode.', 'shopbuilder-pro' ) );
			return ob_get_clean();
		}
		$atts   = shortcode_atts(
			[
				'card_id' => 0,
			],
			$atts,
			'gift_card_info'
		);
		$cardId = $atts['card_id'] ?? 0;
		if ( get_post_type( get_the_ID() ) === BuilderFns::$post_type_tb ) {
			$cardId = $this->get_first_card_id();
		} elseif ( absint( get_query_var( 'rtsb-view-card' ) ) ) {
			$cardId = absint( get_query_var( 'rtsb-view-card' ) );
		}
		if ( $cardId ) {
			$giftCard = GiftCardFns::get_card_by_id( $cardId );
			do_action( 'rtsb/view/card/information', $giftCard );
		}
	}
	/**
	 * Method to render the shortcodes.
	 *
	 * @param array $atts Shortcode attributes.
	 *
	 * @return string
	 * @since  1.0.0
	 */
	public function shortcode_gift_card_activity( $atts, $content = '' ) {
		if ( ! Fns::is_module_active( 'gift_card' ) ) {
			ob_start();
			FnsPro::custom_notice( esc_html__( 'Please activate Gift Card module to use &#91;gift_card_list&#93; shortcode.', 'shopbuilder-pro' ) );
			return ob_get_clean();
		}
		$atts   = shortcode_atts(
			[
				'card_id' => 0,
			],
			$atts,
			'gift_card_activity'
		);
		$cardId = $atts['card_id'] ?? 0;
		if ( get_post_type( get_the_ID() ) === BuilderFns::$post_type_tb ) {
			$cardId = $this->get_first_card_id();
		} elseif ( absint( get_query_var( 'rtsb-view-card' ) ) ) {
			$cardId = absint( get_query_var( 'rtsb-view-card' ) );
		}
        if ( $cardId ) {
            $giftCard = GiftCardFns::get_card_by_id($cardId);
            do_action('rtsb/view/card/activity', $giftCard);
        }
	}
}
