<?php
/**
 * Coupon List Shortcode Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Controllers\Frontend\Shortcodes;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Traits\SingletonTrait;
use RadiusTheme\SBPRO\Modules\SmartCoupons\SmartCouponsFns;
use RadiusTheme\SBPRO\Elementor\Widgets\General\CouponList\Render;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Coupon List Shortcode Class.
 *
 * @package RadiusTheme\SB
 */
class CouponList {
	/**
	 * Singleton.
	 */
	use SingletonTrait;

	/**
	 * Class Constructor.
	 *
	 * @return void
	 */
	private function __construct() {
		add_shortcode( 'rtsb_coupon_list', [ $this, 'shortcode' ] );
	}

	/**
	 * Method to render the shortcodes.
	 *
	 * @param array $atts Shortcode attributes.
	 *
	 * @return string
	 */
	public function shortcode( $atts ) {
		if ( ! Fns::is_module_active( 'smart_coupons' ) ) {
			ob_start();
			FnsPro::custom_notice( esc_html__( 'Please activate Smart Coupons module to use &#91;rtsb_coupon_list&#93; shortcode.', 'shopbuilder-pro' ) );

			return ob_get_clean();
		}

		wp_enqueue_script( 'rtsb-tippy' );

		$atts = shortcode_atts(
			[
				'layout'          => 'rtsb-coupon-layout1',
				'group'           => '',
				'type'            => 'all',
				'include'         => '',
				'exclude'         => '',
				'show_desc'       => 'yes',
				'show_expiration' => 'no',
				'show_validity'   => 'yes',
				'show_discount'   => 'yes',
				'show_coupon'     => 'yes',
				'show_badge'      => 'yes',
				'custom_text'     => esc_html__( 'Coupon', 'shopbuilder-pro' ),
				'coupon_limit'    => 10,
				'visibility'      => 'active,no_expiry,expired',
			],
			$atts,
			'rtsb_coupon_list'
		);

		$settings = [
			'layout'                       => sanitize_text_field( $atts['layout'] ),
			'include_coupon'               => ! empty( $atts['include'] ) ? array_map( 'absint', explode( ',', $atts['include'] ) ) : '',
			'exclude_coupon'               => ! empty( $atts['exclude'] ) ? array_map( 'absint', explode( ',', $atts['exclude'] ) ) : '',
			'coupon_type'                  => ! empty( $atts['type'] ) ? esc_html( $atts['type'] ) : '',
			'filter_groups'                => ! empty( $atts['group'] ) ? array_map( 'absint', explode( ',', $atts['group'] ) ) : '',
			'show_desc'                    => 'yes' === $atts['show_desc'],
			'show_expiration'              => 'yes' === $atts['show_expiration'],
			'show_validity'                => 'yes' === $atts['show_validity'],
			'show_discount'                => 'yes' === $atts['show_discount'],
			'show_coupon'                  => 'yes' === $atts['show_coupon'],
			'show_badge'                   => 'yes' === $atts['show_badge'],
			'custom_text'                  => sanitize_text_field( $atts['custom_text'] ),
			'coupon_limit'                 => (int) $atts['coupon_limit'],
			'coupon_expiration_visibility' => explode( ',', $atts['visibility'] ),
		];

		// Determine template layout.
		switch ( $settings['layout'] ) {
			case 'rtsb-coupon-layout2':
				$template = 'layout2';
				break;
			case 'rtsb-coupon-layout3':
				$template = 'layout3';
				break;
			default:
				$template = 'layout1';
				break;
		}

		$data = [
			'template'        => 'elementor/general/coupon-list/' . $template,
			'id'              => uniqid( 'rtsb_coupon_' ),
			'unique_name'     => 'shortcode_coupon_list',
			'is_grid'         => true,
			'layout'          => $settings['layout'],
			'container_class' => 'rtsb-coupon-grid' . ( $settings['show_badge'] ? ' has-coupon-badge' : ' no-badge' ),
			'content_class'   => 'coupon-item',
			'settings'        => $settings,
			'container_attr'  => [
				'data-text'      => esc_html__( 'Click to copy Coupon Code', 'shopbuilder-pro' ),
				'data-post-text' => esc_html__( 'Copied!', 'shopbuilder-pro' ),
			],
		];

		// Call the template rendering method.
		ob_start();
		Fns::print_html( ( new Render() )->display_content( $data, $settings ), true );

		return ob_get_clean();
	}
}
