<?php
/**
 * Ajax Actions Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Controllers\Frontend\Ajax;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

/**
 * Ajax Actions Class.
 */
class AjaxClearCart {

	/**
	 * Singleton.
	 */
	use SingletonTrait;

	/**
	 * Ajax data.
	 *
	 * @var array
	 */
	public $ajax_data;

	/**
	 * Render class.
	 *
	 * @var array
	 */
	public $render;

	/**
	 * Class Constructor.
	 *
	 * @return void
	 */
	private function __construct() {
		// Remove All Item From Cart.
		add_action( 'wp_ajax_nopriv_rtsb_clear_cart_items', [ $this, 'rtsb_clear_cart_items' ] );
		add_action( 'wp_ajax_rtsb_clear_cart_items', [ $this, 'rtsb_clear_cart_items' ] );

		add_action( 'wp_ajax_nopriv_rtsb_update_cart_total_div', [ $this, 'rtsb_update_cart_total_div' ] );
		add_action( 'wp_ajax_rtsb_update_cart_total_div', [ $this, 'rtsb_update_cart_total_div' ] );
	}

	/**
	 * Load minicart template by ajax
	 *
	 * @return void
	 */
	public function rtsb_update_cart_total_div() {
		$date = [
			'msg'  => '',
			'data' => '',
		];
		if ( ! Fns::verify_nonce() ) {
			wp_send_json_error( $date );
		}

		ob_start();
			woocommerce_cart_totals();
		$total_html = ob_get_clean();

		wp_send_json(
			[
				'msg'  => 'Cart Total Updated',
				'data' => $total_html,
			]
		);
		wp_die();
	}
	/**
	 * Load minicart template by ajax
	 *
	 * @return void
	 */
	public function rtsb_clear_cart_items() {
		if ( ! Fns::verify_nonce() ) {
			wp_send_json_error();
		}
		WC()->cart->empty_cart();
		wp_die();
	}
}
